<?php
/***********************************************
* File      :   caldav.php
* Project   :   Z-Push
* Descr     :   This backend is for carddav.
*               Based on the vcarddir and caldav
*               backend.
* Created   :   7.12.2010
*
* � Bo Simonsen, bo.geekworld.dk
* � Zarafa Deutschland GmbH, www.zarafaserver.de
* This file is distributed under GPL v2.
* Consult LICENSE file for details
************************************************/

include_once('diffbackend.php');
require_once('class_webdav_client.php');

function in_array_ci($token, $array) {
  foreach($array as $a) {
    if(!strcasecmp($a, $token)) {
      return true;
    }
  }
  
  return false;
}

class BackendCardDav extends BackendDiff {
    var $_user;
    var $_devid;
    var $_protocolversion;
    var $_config;
    var $_path;

    
	
	
    function Logon($username, $domain, $password) {
		debugLog('CardDAV::logon to webdav server');
		$this->wdc = new webdav_client();
		$this->wdc->set_server(CARDDAV_SERVER);
		$this->wdc->set_port(CARDDAV_PORT);
		$this->wdc->set_user($username);
		$this->wdc->set_pass($password);

		// use HTTP/1.1
		$this->wdc->set_protocol(0);
		// enable debugging
		$this->wdc->set_debug(false);
		
		
    		# Replace variables in config
		    # Enter variables to replace ...

		    $cardav_path = str_replace( "%u", $username,CARDDAV_PATH );
		    debugLog("CardDAV::Config: Updated CALDAV_PATH with " .$cardav_path);
													
		if (!$this->wdc->open()) {
			debugLog('CardDAV::could not open server connection');
			return false;
		}
		
		
		// check if server supports webdav rfc 2518
		if (!$this->wdc->check_webdav($cardav_path)) {
			debugLog('CardDAV::server does not support webdav or user/password may be wrong');
			return false;
		}	
		$this->_path = $cardav_path;

		debugLog('CardDAV::Successful Logon To WebDAV Server');
        return true;
    }

        // completing protocol
    function Logoff() {
		debugLog('CardDAV::Closing Connection');
		if ($this->wdc) {
			$this->wdc->close();
		}
        return true;
    }


    function Setup($user, $devid, $protocolversion) {
        $this->_user = $user;
        $this->_devid = $devid;
        $this->_protocolversion = $protocolversion;

        return true;
    }

    function SendMail($rfc822, $forward = false, $reply = false, $parent = false) {
        return false;
    }

    function GetWasteBasket() {
        return false;
    }

    function GetMessageList($folderid, $cutoffdate) {
        debugLog('CardDAV::GetMessageList('.$this->_path.')');
        if ($folderid != "contacts")
            return false;

        $messages = array();

        $dir = $this->wdc->ls($this->_path);
        if(!$dir) {
            debugLog('CardDAV::GetMessageList '.$this->_path.' not dir');
            return false;
        }

        foreach($dir as $e) {
			$e['href'] = substr($e['href'], strlen($this->_path));
			$test = split('/', $e['href']);
			$last=array_pop($test);
            if (trim($last) != "") {
                $message = $this->StatMessage($folderid, $last);
                $messages[] = $message;
            }
        }
        debugLog('CardDAV::GetMessageList length'.count($messages));
        return $messages;
    }

    function GetFolderList() {
        debugLog('CardDAV::GetFolderList()');
        $contacts = array();
        $folder = $this->StatFolder("contacts");
        $contacts[] = $folder;

        return $contacts;
    }

    function GetFolder($id) {
        debugLog('CardDAV::GetFolder('.$id.')');
        if($id == "contacts") {
            $folder = new SyncFolder();
            $folder->serverid = $id;
            $folder->parentid = "0";
            $folder->displayname = "Contacts";
            $folder->type = SYNC_FOLDER_TYPE_CONTACT;

            return $folder;
        } else return false;
    }

    function StatFolder($id) {
        debugLog('CardDAV::StatFolder('.$id.')');
        $folder = $this->GetFolder($id);

        $stat = array();
        $stat["id"] = $id;
        $stat["parent"] = $folder->parentid;
        $stat["mod"] = $folder->displayname;

        return $stat;
    }

    function GetAttachmentData($attname) {
        return false;
    }

    function StatMessage($folderid, $id) {
        debugLog('CardDAV::StatMessage('.$folderid.', '.$id.')');
        if($folderid != "contacts")
            return false;

        if(trim($id == ""))
            return false;

        $dir = $this->wdc->ls($this->_path);
        if(!$dir)
            return false;

        foreach($dir as $e) {
			$test = split('/', $e['href']);
			$last=array_pop($test);
			if ($last == $id) {
		        debugLog('CardDAV::StatMessage('.$folderid.', '.$id.')');
				if ($folderid == "contacts") {
					$message = array();
					$message["id"] = $last;
					if (array_key_exists('lastmodified', $e)) {
						$message["mod"] = $e['lastmodified'];
						debugLog('CardDAV::message moded at '.$e['lastmodified']);
					} else {
						$message["mod"] = date("d.m.Y H:i:s");
					}
					$message["flags"] = 1; // always 'read'
					return $message;
				}
			}
        }

		return false;
    }


    function GetMessage($folderid, $id, $truncsize, $mimesupport = 0) {
        debugLog('CardDAV::GetMessage('.$folderid.', '.$id.', ..)');
		$test = split('/', $id);
		$last=array_pop($test);
        debugLog("CarDAV::Getting123 ".$id);
		$stat = $this->wdc->get($this->_path.$last, $output); 
	//$stat = $this->wdc->get($this->_path.$id, $output); 
	if ($stat != 200) {
          debugLog('CardDAV::Could not retrieve file from server');
      	  return;
        }

        $types = array ('dom' => 'type', 'intl' => 'type', 'postal' => 'type', 'parcel' => 'type', 'home' => 'type', 'work' => 'type',
            'pref' => 'type', 'voice' => 'type', 'fax' => 'type', 'msg' => 'type', 'cell' => 'type', 'pager' => 'type',
            'bbs' => 'type', 'modem' => 'type', 'car' => 'type', 'isdn' => 'type', 'video' => 'type',
            'aol' => 'type', 'applelink' => 'type', 'attmail' => 'type', 'cis' => 'type', 'eworld' => 'type',
            'internet' => 'type', 'ibmmail' => 'type', 'mcimail' => 'type',
            'powershare' => 'type', 'prodigy' => 'type', 'tlx' => 'type', 'x400' => 'type',
            'gif' => 'type', 'cgm' => 'type', 'wmf' => 'type', 'bmp' => 'type', 'met' => 'type', 'pmb' => 'type', 'dib' => 'type',
            'pict' => 'type', 'tiff' => 'type', 'pdf' => 'type', 'ps' => 'type', 'jpeg' => 'type', 'qtime' => 'type',
            'mpeg' => 'type', 'mpeg2' => 'type', 'avi' => 'type',
            'wave' => 'type', 'aiff' => 'type', 'pcm' => 'type',
            'x509' => 'type', 'pgp' => 'type', 'text' => 'value', 'inline' => 'value', 'url' => 'value', 'cid' => 'value', 'content-id' => 'value',
            '7bit' => 'encoding', '8bit' => 'encoding', 'quoted-printable' => 'encoding', 'base64' => 'encoding',
        );


        // Parse the vcard
        $message = new SyncContact();

        $data = $output;
        $data = str_replace("\x00", '', $data);
        $data = str_replace("\r\n", "\n", $data);
        $data = str_replace("\r", "\n", $data);
        $data = preg_replace('/(\n)([ \t])/i', '', $data);

        $lines = explode("\n", $data);

        $vcard = array();
        foreach($lines as $line) {
            if (trim($line) == '')
                continue;
            $pos = strpos($line, ':');
            if ($pos === false)
                continue;

            $field = trim(substr($line, 0, $pos));
            $value = trim(substr($line, $pos+1));

            $fieldparts = preg_split('/(?<!\\\\)(\;)/i', $field, -1, PREG_SPLIT_NO_EMPTY);

            $type = strtolower(array_shift($fieldparts));

            $fieldvalue = array();

            foreach ($fieldparts as $fieldpart) {
                if(preg_match('/([^=]+)=(.+)/', $fieldpart, $matches)){
                    if(!in_array(strtolower($matches[1]),array('value','type','encoding','language')))
                        continue;
                    if(isset($fieldvalue[strtolower($matches[1])]) && is_array($fieldvalue[strtolower($matches[1])])){
                        $fieldvalue[strtolower($matches[1])] = array_merge($fieldvalue[strtolower($matches[1])], preg_split('/(?<!\\\\)(\,)/i', $matches[2], -1, PREG_SPLIT_NO_EMPTY));
                    }else{
                        $fieldvalue[strtolower($matches[1])] = preg_split('/(?<!\\\\)(\,)/i', $matches[2], -1, PREG_SPLIT_NO_EMPTY);
                    }
                }else{
                    if(!isset($types[strtolower($fieldpart)]))
                        continue;
                    $fieldvalue[$types[strtolower($fieldpart)]][] = $fieldpart;
                }
            }
            //
            switch ($type) {
                case 'categories':
                    //case 'nickname':
                    $val = preg_split('/(?<!\\\\)(\,)/i', $value);
                    break;
                default:
                    $val = preg_split('/(?<!\\\\)(\;)/i', $value);
                    break;
            }
            if(isset($fieldvalue['encoding'][0])){
                switch(strtolower($fieldvalue['encoding'][0])){
                    case 'q':
                    case 'quoted-printable':
                        foreach($val as $i => $v){
                            $val[$i] = quoted_printable_decode($v);
                        }
                        break;
                    case 'b':
                    case 'base64':
                        foreach($val as $i => $v){
                            $val[$i] = base64_decode($v);
                        }
                        break;
                }
            }else{
                foreach($val as $i => $v){
                    $val[$i] = $this->unescape($v);
                }
            }
            $fieldvalue['val'] = $val;
            $vcard[$type][] = $fieldvalue;
        }

        if(isset($vcard['email'][0]['val'][0]))
            $message->email1address = $vcard['email'][0]['val'][0];
        if(isset($vcard['email'][1]['val'][0]))
            $message->email2address = $vcard['email'][1]['val'][0];
        if(isset($vcard['email'][2]['val'][0]))
            $message->email3address = $vcard['email'][2]['val'][0];

        if(isset($vcard['tel'])){
            foreach($vcard['tel'] as $tel) {
                if(!isset($tel['type'])){
                    $tel['type'] = array();
                }
                if(in_array_ci('car', $tel['type'])){
                    $message->carphonenumber = $tel['val'][0];
                }elseif(in_array_ci('pager', $tel['type'])){
                    $message->pagernumber = $tel['val'][0];
                }elseif(in_array_ci('cell', $tel['type'])){
                    $message->mobilephonenumber = $tel['val'][0];
                }elseif(in_array_ci('home', $tel['type'])){
                    if(in_array_ci('fax', $tel['type'])){
                        $message->homefaxnumber = $tel['val'][0];
                    }elseif(empty($message->homephonenumber)){
                        $message->homephonenumber = $tel['val'][0];
                    }else{
                        $message->home2phonenumber = $tel['val'][0];
                    }
                }elseif(in_array_ci('work', $tel['type'])){
                    if(in_array_ci('fax', $tel['type'])){
                        $message->businessfaxnumber = $tel['val'][0];
                    }elseif(empty($message->businessphonenumber)){
                        $message->businessphonenumber = $tel['val'][0];
                    }else{
                        $message->business2phonenumber = $tel['val'][0];
                    }
                }elseif(empty($message->homephonenumber)){
                    $message->homephonenumber = $tel['val'][0];
                }elseif(empty($message->home2phonenumber)){
                    $message->home2phonenumber = $tel['val'][0];
                }else{
                    $message->radiophonenumber = $tel['val'][0];
                }
            }
        }
        //;;street;city;state;postalcode;country
        if(isset($vcard['adr'])){
            foreach($vcard['adr'] as $adr) {
                if(empty($adr['type'])){
                    $a = 'other';
                }elseif(in_array_ci('home', $adr['type'])){
                    $a = 'home';
                }elseif(in_array_ci('work', $adr['type'])){
                    $a = 'business';
                }else{
                    $a = 'other';
                }
                if(!empty($adr['val'][2])){
                    $b=$a.'street';
                    $message->$b = $adr['val'][2];
                }
                if(!empty($adr['val'][3])){
                    $b=$a.'city';
                    $message->$b = $adr['val'][3];
                }
                if(!empty($adr['val'][4])){
                    $b=$a.'state';
                    $message->$b = $adr['val'][4];
                }
                if(!empty($adr['val'][5])){
                    $b=$a.'postalcode';
                    $message->$b = $adr['val'][5];
                }
                if(!empty($adr['val'][6])){
                    $b=$a.'country';
                    $message->$b = $adr['val'][6];
                }
            }
        }

        if(!empty($vcard['fn'][0]['val'][0]))
            $message->fileas = $vcard['fn'][0]['val'][0];
        if(!empty($vcard['n'][0]['val'][0]))
            $message->lastname = $vcard['n'][0]['val'][0];
        if(!empty($vcard['n'][0]['val'][1]))
            $message->firstname = $vcard['n'][0]['val'][1];
        if(!empty($vcard['n'][0]['val'][2]))
            $message->middlename = $vcard['n'][0]['val'][2];
        if(!empty($vcard['n'][0]['val'][3]))
            $message->title = $vcard['n'][0]['val'][3];
        if(!empty($vcard['n'][0]['val'][4]))
            $message->suffix = $vcard['n'][0]['val'][4];
        if(!empty($vcard['bday'][0]['val'][0])){
            $tz = date_default_timezone_get();
            date_default_timezone_set('UTC');
            $message->birthday = strtotime($vcard['bday'][0]['val'][0]);
            date_default_timezone_set($tz);
        }
        if(!empty($vcard['org'][0]['val'][0]))
            $message->companyname = $vcard['org'][0]['val'][0];
        if(!empty($vcard['note'][0]['val'][0])){
            $message->body = $vcard['note'][0]['val'][0];
            $message->bodysize = strlen($vcard['note'][0]['val'][0]);
            $message->bodytruncated = 0;
        }
        if(!empty($vcard['role'][0]['val'][0]))
            $message->jobtitle = $vcard['role'][0]['val'][0];//$vcard['title'][0]['val'][0]
        if(!empty($vcard['url'][0]['val'][0]))
            $message->webpage = $vcard['url'][0]['val'][0];
        if(!empty($vcard['categories'][0]['val']))
            $message->categories = $vcard['categories'][0]['val'];

        if(!empty($vcard['photo'][0]['val'][0]))
            $message->picture = base64_encode($vcard['photo'][0]['val'][0]);

        return $message;
    }

    function DeleteMessage($folderid, $id) {
	$http_status_array = $this->wdc->delete($this->_path.'/'.$id);
	if ($http_status_array['status'] == "200") {
		return true;
	} else {
		return false;
	}
    }

    function SetReadFlag($folderid, $id, $flags) {
        return false;
    }

    function ChangeMessage($folderid, $id, $message) {


	if (trim($id) != "") {
		$return = $this->StatMessage($folderid, $id);
	} else {
		$return = false;
	}
	if ($return === false) {
		debugLog('CardDAV::Found new message on device');	
		#create new id, this is a new record from device.
		$date   = date('Ymd\THisT');
		$unique = substr(microtime(), 2, 4);
		$base   = 'aAbBcCdDeEfFgGhHiIjJkKlLmMnNoOpPrRsStTuUvVxXuUvVwWzZ1234567890';
		$start  = 0;
		$end    = strlen( $base ) - 1;
		$length = 6;
		$str    = null;
		for( $p = 0; $p < $length; $p++ )
			$unique .= $base{mt_rand( $start, $end )};
		$id = $date.'-'.$unique.".vcf";
	} else {
		debugLog('CardDAV::Event Already On Server');			
	}

        debugLog('CardDAV:ChangeMessage('.$folderid.', '.$id.', ..)');
        $mapping = array(
            'fileas' => 'FN',
            'lastname;firstname;middlename;title;suffix' => 'N',
            'email1address' => 'EMAIL;INTERNET',
            'email2address' => 'EMAIL;INTERNET',
            'email3address' => 'EMAIL;INTERNET',
            'businessphonenumber' => 'TEL;WORK',
            'business2phonenumber' => 'TEL;WORK',
            'businessfaxnumber' => 'TEL;WORK;FAX',
            'homephonenumber' => 'TEL;HOME',
            'home2phonenumber' => 'TEL;HOME',
            'homefaxnumber' => 'TEL;HOME;FAX',
            'mobilephonenumber' => 'TEL;CELL',
            'carphonenumber' => 'TEL;CAR',
            'pagernumber' => 'TEL;PAGER',
            ';;businessstreet;businesscity;businessstate;businesspostalcode;businesscountry' => 'ADR;WORK',
            ';;homestreet;homecity;homestate;homepostalcode;homecountry' => 'ADR;HOME',
            ';;otherstreet;othercity;otherstate;otherpostalcode;othercountry' => 'ADR',
            'companyname' => 'ORG',
            'body' => 'NOTE',
            'jobtitle' => 'ROLE',
            'webpage' => 'URL',
        );
        $data = "BEGIN:VCARD\nVERSION:2.1\nPRODID:Z-Push\n";
        foreach($mapping as $k => $v){
            $val = '';
            $ks = split(';', $k);
            foreach($ks as $i){
                if(!empty($message->$i)) {
                    $val .= $this->escape($message->$i);
            	}
            	$val.=';';
            }
            if(empty($val) or strlen($val) == 1)
                continue;
            $val = substr($val,0,-1);
            if(strlen($val)>50){
                $data .= $v.":\n\t".substr(chunk_split($val, 50, "\n\t"), 0, -1);
            }else{
                $data .= $v.':'.$val."\n";
            }
        }
        if(!empty($message->categories))
            $data .= 'CATEGORIES:'.implode(',', $this->escape($message->categories))."\n";
        if(!empty($message->picture))
            $data .= 'PHOTO;ENCODING=BASE64;TYPE=JPEG:'."\n\t".substr(chunk_split($message->picture, 50, "\n\t"), 0, -1);
        if(isset($message->birthday))
            $data .= 'BDAY:'.date('Y-m-d', $message->birthday)."\n";
        $data .= "END:VCARD";
               
        $retput = $this->wdc->put($this->_path.$id, $data );
        
        debugLog("carddav::data putted $retput");
        
        return $this->StatMessage($folderid, $id);

    }

    function MoveMessage($folderid, $id, $newfolderid) {
        return false;
    }

    // -----------------------------------

    function escape($data){
        if (is_array($data)) {
            foreach ($data as $key => $val) {
                $data[$key] = $this->escape($val);
            }
            return $data;
        }
        $data = str_replace("\r\n", "\n", $data);
        $data = str_replace("\r", "\n", $data);
        $data = str_replace(array('\\', ';', ',', "\n"), array('\\\\', '\\;', '\\,', '\\n'), $data);
        return $data;
    }

    function unescape($data){
        $data = str_replace(array('\\\\', '\\;', '\\,', '\\n','\\N'),array('\\', ';', ',', "\n", "\n"),$data);
        return $data;
    }
};
?>
