\name{xrt.dump}
\title{Write a XRT grid file}
\author{A. Gebhardt}
\usage{xrt.dump(x, y, z, file="xrt.dat")
}
\alias{xrt.dump}
\arguments{
  \item{x,y,z}{grid data, see e.g. \code{\link{contour}}}
  \item{file}{name for temporary file, default "xrt.dat"}
}
\description{
Intended for internal use in \code{\link{xrt.plot}}.
}
\value{None
}
\references{XRT/3d is a product of
  KL Group Inc.,
  260 King Street East,
  Toronto, Ontario,
  CANADA  M5A 1K3,
  (800) 663-4723 or (416) 594-1026,
  Fax: (416) 594-1919    Email: info@klg.com,
  http://www.klg.com
}
\seealso{\code{\link{xrt.plot}}, \code{\link{xrt.read}}, \code{\link{contour}},\code{\link{image}}
}
\examples{
x<-seq(-2*pi,2*pi,length=20)
y<-seq(-pi,pi,length=10)
z<-outer(x,y,function(x,y)sin(x+y))+0.5*rnorm(10*20)
xrt.dump(x,y,z,"xrt.dat")
}
\keyword{plot}
