xrt.dump <- function(x,y,z,file="xrt.dat")
  {
    which.na<-function (x) seq(along = x)[is.na(x)]
 
    if(!is.matrix(z))
      stop("z is not a matrix")
    # write grid dim
    nx<-dim(z)[2]
    ny<-dim(z)[1]
    write(paste("GRID ", ny, nx, sep = " "), 
          file = file)
    # write NA value
    na<-min(z)-1000
    write(na, file = file, append = T)
    # write grid spacing
    dx<-diff(x)[1]
    dy<-diff(y)[1]
    write(paste(dx, dy, sep=" "), file = file, append = T)
    # write SE-corner of grid
    write(paste(range(x)[1], range(y)[1], sep=" "), file = file, append = T)
    # write z values (NAs coded as min(z)-1000)
    z[which.na(z)]<-na
    write(z,ncolumns=ny, file = file, append = T)
  }
