      
      subroutine idw(nx,x,nd,ndim,loc,dat,ret,power,dvec1,dvec2)
      implicit none
c     
c     inverse distance weighted average 
c     
      integer nx,nd,ndim
      double precision x(nx,*),loc(nd,*),dat(*),ret(*),dst,power,
     +     dvec1(*),dvec2(*)

      double precision distn,wsum
      external distn, dsubmv

      double precision one,zero
      parameter (one=1.0d+0,zero=0.0d+0)
      
      integer i,j
      double precision dummy
      do 10 j=1,nx
         dummy=zero
         wsum=zero
         call dsubmv(x,nx,ndim,j,1,j,ndim,nx,dvec1,1)

         do 20 i=1,nd
            call dsubmv(loc,nd,ndim,i,1,i,ndim,nd,dvec2,1)
            if (power.eq.one) then
               dst=distn(ndim,dvec1,dvec2)
            else
               dst=exp(power*log(distn(ndim,dvec1,dvec2)))
            end if
            if (dst.ne.zero) then                                                
               dummy=dummy+one/dst*dat(i)
               wsum=wsum+one/dst
            else                                                                  
               dummy=dat(i)
               wsum=one
               go to 30                                                            
            end if            
 20      continue                                                                
 30      ret(j)=dummy/wsum
 10   continue                                                                  
      return                                                                    
      end                                                                       
                                                                                
      double precision function distn(n,a,x)
      implicit none
      integer n
      double precision a(*),x(*)

      double precision one,zero
      parameter (one=1.0d+0,zero=0.0d+0)
      
      integer i
      distn=zero
      do 10 i=1,n
         distn=distn+(a(i)-x(i))*(a(i)-x(i))
 10   continue
      distn=sqrt(distn)
      return
      end                                                                       
