\name{krige.points}
\alias{krige.points}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{ Universal kriging }
\description{
  Performs (2D) universal kriging at given points using data and variogram
  objects prepared with \code{\link[sgeostat]{point}},
  \code{\link[sgeostat]{pair}}, \code{\link[sgeostat]{est.variogram}}
  and   \code{\link[sgeostat]{fit.variogram}} from library
  \code{sgeostat}.
}
\usage{
krige.points(point.obj, at, var.mod.obj, x, y, maxdist=NULL, extrap=FALSE, border=NULL, trend=0, rsearch=0, nsearch=0, nsmin=-1, nsmax=-1, mode=3, duplicate = "error", dupfun = NULL)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{point.obj}{ spatial data, class \code{"point"}}
  \item{at}{ name of variable of interest in \code{point.obj} }
  \item{var.mod.obj}{ variogram model, generated by \code{\link[sgeostat]{fit.variogram}}  }
  \item{x}{ x coordinates of prediction points }
  \item{y}{ y coordinates of prediction points }
  \item{maxdist}{ synonym for  \code{rsearch}, for compatibility with
    \code{sgeostat}}
  \item{extrap}{logical, indicates whether to extrapolate beyond convex
    hull of data points, default \code{FALSE} }
  \item{border}{optional polygon (list with two components \code{x} and
    \code{y} of same length) representing a (possibly non convex) region
    of interest to be used instead of the convex hull. Needs
    \code{extrap=FALSE}.}
  \item{trend}{ order of trend function }
  \item{rsearch}{ fixed search radius }
  \item{nsearch}{ fixed nearest neighbour search }
  \item{nsmin}{ minimum no of points in search neighbourhood, default 0}
  \item{nsmax}{ maximum no of points in search neighbourhood,
   default \code{length(point.obj[at])} }
  \item{mode}{1 - calculate only krige prediction, 2 - calculate
   only krige variance (useful for network design purposes),
   3 - both (default)}
  \item{duplicate}{
    indicates how to handle duplicate data points. Possible values are
    \code{"error"} - produces an error message, \code{"strip"} - remove
    duplicate z values, \code{"mean"},\code{"median"},\code{"user"}  -
    calculate mean , median or user defined function of duplicate z
    values.}
  \item{dupfun}{this function is applied to duplicate points if
    \code{duplicate="user"}}
}
\details{
  Trend models are coded via the \code{trend} parameter (only up to
  order 2 supported):
  \tabular{lr}{
    \code{trend}   \tab trend function \cr
    0              \tab \code{z~1}     \cr
    1              \tab \code{z~x+y+1}     \cr
    2              \tab \code{z~x+y+I(x^2)+I(y^2)+x*y} 
  } 
 

  The krige system is solved via the LAPACK routine DGESV.

  If \code{mode} is set to 2 (default is 3) only kriging variances are
  calculated. In this case the values in \code{at} (the measurements)
  are not used. This may be useful for experimental design applications
  where only new locations are given and measurements do not yet exist.
  Of course \code{var.mod} has to be given (computed from an existing
  dataset).
}
\value{
  a list with the components
  \item{x }{vector of x coordinates of grid}
  \item{y }{vector of y coordinates of grid}
  \item{z }{matrix of predicted values, see also \code{mode}}
  \item{var }{matrix of prediction variances}
  \item{done }{matrix with 0-1 coding of success of kriging}
  
}
\references{ ftp://ftp-stat.uni-klu.ac.at/pub/R/contrib }
\author{ A. Gebhardt <albrecht.gebhardt@uni-klu.ac.at> }
\note{ In contrast to the interpreted \code{\link[sgeostat]{krige}} function from library
  \code{sgeostat} this function is written in
  FORTRAN, so it should be reasonably faster. }

\seealso{ 
  \code{\link{krige.grid}},\code{\link[sgeostat]{krige}}
}
\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.vmod"))==0){require(sgeostat); example(fit.variogram)}
if(length(ls(pat="maas.bank"))==0) data(maas.bank)
}
maas.kpoints <- krige.points(maas.point, "zinc", maas.vmod,
                           c(179500,180000),c(330000,332000),rsearch = 600)
}
\keyword{ rgeostat }%-- one or more ...
