\name{idw}
\alias{idw}
\title{Inverse distance weighted average}
\description{
  Calculates an inverse distance weighted interpolator (optionally a
  power of the inverse distance is used).
}
\usage{
idw(x, loc, data, power=1)
}
\arguments{
  \item{x}{ matrix containing (by row) locations of points where to
    generate interpolates, number of columns indicates dimension.
  }
  \item{loc}{ matrix containing locations of data points, same number of
    columns as \code{x}.}
  \item{data}{ vector with data, same length as \code{loc}. }
  \item{power}{ power of distance to use for inverse weighting (default
    1). }
}
\details{
  Computes
  \deqn{z_0=\sum_{i=1}^n w_i*x_i}{z_0=sum_{i=1}^n w_i*z_i}
  with
  \deqn{w_i=\sum_{j=1,n}^n d(x_0,x_j)^p/d(x_0,x_i)^p.}{
    w_i=sum_{j=1,n}^n d(x_0,x_j)^p / d(x_0,x_i)^p.}  }

  \value{
    A vector with interpolated values according to the locations given in
    \code{x}.
}
\author{ A. Gebhardt <agebhard@uni-klu.ac.at> }

\seealso{ \code{\link{interp}} }

\examples{
# four data points:
x <- matrix(c(-1, -0.5, -0.2, -0.2, 1, 0.5, 0.2, 0.2), 4, 2, byrow = T)
z <- c(2.5, 0.5, 0.5, 2.5)
# a simple grid:
res <- 100
xx <- seq(-1, 1, length=res)
xy <- seq(-1, 1, length=res)
xg <- cbind(c(matrix(xx, res, res, byrow=T)),
          c(matrix(xy,res,res,byrow=F)))
# inverse distance weighted average:
zg <- idw(xg, x, z)
# some display:
image(xx, xy, t(matrix(zg, res, res)))
points(x)
# or an array of displays with variyng power parameter:
opar<-par(mfrow=c(4,4))
for (i in seq(1,4,length=16)){
  zg<-idw(xg, x, z, i)
  image(xx, xy, t(matrix(zg, res, res)))
  title(paste("p=",i))
}
par(opar)
}
\keyword{ rgeostat }
