"plot.krige.map" <-
  function(obj, show.data=FALSE, show.snb=FALSE,
           snb.i=NULL, snb.j=NULL, var=FALSE, bias=FALSE, nlevels=12,legend.pos=0,zlim=NULL,vlim=NULL,...){
    if(!inherits(obj,"krige.map"))
      stop("argument is not a krige map!")
    # plot estimated z or var:
    if(!is.null(zlim)){
      zmin <- zlim[1]
      zmax <- zlim[2]
      zrange <- zmax-zmin
    } else {
      zmin <- min(c(obj$z,obj$data[[obj$at]]),na.rm=T)
      zmax <- max(c(obj$z,obj$data[[obj$at]]),na.rm=T)
      zrange <- zmax-zmin
      zlim <-c(zmin,zmax)
    }
    # plot dims:
    xlim<-range(obj$x)
    ylim<-range(obj$y)
    dx <- diff(xlim)
    dy <- diff(ylim)

    # generate equal-squaled plot!
    if(dx>dy){
      pref.legend.pos<-c("top","bottom")
      ymid<-sum(ylim)/2
      ylim<-ymid+c(-dx/2,dx/2)
    }else{
      pref.legend.pos<-c("left","right")
      xmid<-sum(xlim)/2
      xlim<-xmid+c(-dy/2,dy/2)
    }
    
    
    # color levels for variances:
    if(var){
      if(!is.null(vlim)){
        vmin <- vlim[1]
        vmax <- vlim[2]
        vrange <- vmax-vmin
      } else {
        vmin <- min(obj$var,na.rm=T)
        vmax <- max(obj$var,na.rm=T)
        vrange <- vmax-vmin
        vlim <-c(vmin,vmax)
      }
      vlevels <- pretty(vlim, nlevels)
      vllevels <- length(vlevels)
      vcolors <- topo.colors(vllevels+1)
    }

    if(bias){
      if(is.null(obj$lambda0)){
        stop("bias plot only for bayesian kriging")
      }
    }

    if(bias){
      bmin <- min(obj$lambda0,na.rm=T)
      bmax <- max(obj$lambda0,na.rm=T)
      brange <- bmax-bmin
      blim <-c(bmin,bmax)
      
      blevels <- pretty(blim, nlevels)
      bllevels <- length(blevels)
      bcolors <- topo.colors(bllevels+1)
    }
    
    # color levels for prediction
    if(var)
      levels <- pretty(vlim, nlevels)
    else
      if(bias)
        levels <- pretty(blim, nlevels)
      else
        levels <- pretty(zlim, nlevels)
    
    llevels <- length(levels)
    colors <- heat.colors(llevels+1)

    # the main plot commands:
    if(var){
      image(obj$x,obj$y,obj$var,col=vcolors,zlim=vlim,xlim=xlim,ylim=ylim,...)
      contour(obj$x,obj$y,obj$var,add=T,levels=vlevels)
    }
    else{
      if(bias){
        image(obj$x,obj$y,obj$lambda0,col=bcolors,zlim=blim,xlim=xlim,ylim=ylim,...)
        contour(obj$x,obj$y,obj$lambda0,add=T,levels=blevels)
      }else {
        image(obj,col=colors,zlim=zlim,xlim=xlim,ylim=ylim,...)
        contour(obj,add=T,levels=levels)
      }
    }
    # add legend:
    if(!var)
      add.legend(zlim,levels,colors,xlim,ylim,100,label=obj$at,
                 half="full",legend.pos=pref.legend.pos[1])
    else
      add.legend(vlim,vlevels,vcolors,xlim,ylim,100,label=paste("var. of",obj$at),
                 half="full",legend.pos=pref.legend.pos[1])
      
    plevels<-apply(outer(obj$data[[obj$at]],levels,">="),1,
                   function(x) as.numeric(x)%*%as.numeric(x))
    
    # add data points
    if(show.data){
      points(obj$data$x,obj$data$y,col=c(colors)[plevels],pch=15)
      points(obj$data$x,obj$data$y,col="black",pch=0)
    }
    # let the user mark grid points and add their search neighbourhood
    if(show.snb){
      tmp<-expand.grid(obj$x,obj$y)
      points(tmp$Var1,tmp$Var2,type="n")
      if(is.null(snb.i) | is.null(snb.j)){
        cat("select points to place search neighbourhoods ...\n")
        lst<-identify(tmp$Var1,tmp$Var2,labels=rep("",length(tmp$Var1)))
        cat("\n")
        # mirror indices for index order in krige.grid:
        lst.krg<-(lst-1)%/%length(obj$x)+1+lst%%length(obj$x)*length(obj$x)
      } else {
        if(length(snb.i)!=length(snb.i))
          stop("snb.i and snb.j have different lengths!")
        lst<-length(obj$y)*(snb.i-1)+snb.j
      }
      mypch<-0
      ret<-NULL
      ret$gridpoints<-NULL
      ret$snb<-list()
      cnt<-0
      if(!is.null(obj$lambda)){
        # weight range:
        wlim<-range(obj$lambda[,lst.krg])
        # center range around 0, so that white=0:
        if(wlim[1]>0)wlim[1]<-0
        if(wlim[2]<0)wlim[2]<-0
        if(abs(wlim[1])<abs(wlim[2]))
          wlim[1]<- -wlim[2]
        else
          wlim[2]<- -wlim[1]
        wlevels<-pretty(wlim,50)
        lwlevels<-length(wlevels)
        wcolors<-cm.colors(lwlevels)
        # weight legend:
        add.legend(wlim,wlevels,wcolors,xlim,ylim,100,
                   label="krige weights",half="full",
                   legend.pos=pref.legend.pos[2])
      }
      for (ind in 1:length(lst.krg)){
        i <- lst.krg[ind]
        if(!is.null(obj$tile))
          it<-obj$tile[i]
        else
          it<-i
        cnt <- cnt+1
        ret$gridpoints <- c(ret$gridpoints,it)
        
        neighbours<-cbind(obj$data$x[obj$snb[,it]==1],obj$data$y[obj$snb[,it]==1])
        if(!is.null(obj$lambda)){
        #color levels for krige weights:
          weights<-obj$lambda[,i]
          wgtlevels<-apply(outer(obj$lambda[,i],wlevels,">="),1,
                           function(x) as.numeric(x)%*%as.numeric(x))[obj$snb[,it]==1]
        }
        ret$snb[[cnt]]<-list()
        if(dim(neighbours)[1]!=0){
          # points(neighbours,pch=mypch)
          # show krigeweights
          if(!is.null(obj$lambda)){
            points(neighbours,col=wcolors[wgtlevels],pch=15,cex=1.5)
          } else {
            points(neighbours,col="white",pch=15,cex=1.5)
          }
          points(neighbours,col="black",pch=0,cex=1.5)
          # show data
          points(neighbours,col=c(colors)[plevels][obj$snb[,it]==1],pch=15,cex=0.7)
          points(neighbours,col="black",pch=0,cex=0.7)
          
          ret$snb[[cnt]] <- (1:length(obj$snb[,it]))[obj$snb[,it]==1]
        
          hpts <- chull(neighbours)
          hpts <- c(hpts,hpts[1])
          lines(neighbours[hpts,])

          if(!is.null(obj$tile)){
            # tile:
            itpnts <- (obj$tile==it)
            tilepoints<-cbind(tmp$Var1[itpnts],tmp$Var2[itpnts])
            dx<-obj$x[2]-obj$x[1]
            dy<-obj$y[2]-obj$y[1]
            if(length(tilepoints)<9)
              points(tilepoints,pch=mypch+8)
            else{
              tilecorners<-
                tilepoints-cbind(rep(dx/2,length=dim(tilepoints)[1]),
                                 rep(dy/2,length=dim(tilepoints)[1]))
              tilecorners<-
                rbind(tilecorners,tilepoints+
                      cbind(rep(dx/2,length=dim(tilepoints)[1]),
                            rep(dy/2,length=dim(tilepoints)[1])))
              tilecorners<-
                rbind(tilecorners,tilepoints+
                      cbind(rep(dx/2,length=dim(tilepoints)[1]),
                            rep(-dy/2,length=dim(tilepoints)[1])))
              tilecorners<-
                rbind(tilecorners,tilepoints+
                      cbind(rep(-dx/2,length=dim(tilepoints)[1]),
                            rep(dy/2,length=dim(tilepoints)[1])))
            
              hpts<-chull(tilecorners)
              hpts<-c(hpts,hpts[1])
              lines(tilecorners[hpts,])
            }
          } else {
            # grid:
            gridpoint<-cbind(tmp$Var1[lst[ind]],tmp$Var2[lst[ind]])
            points(gridpoint,pch=mypch+8)
            if(!is.null(obj$rsearch)){
              #browser()
              curve(gridpoint[,2]+sqrt(obj$rsearch^2-(x-gridpoint[,1])^2),gridpoint[,1]-obj$rsearch,gridpoint[,1]+obj$rsearch, add=T)
              curve(gridpoint[,2]-sqrt(obj$rsearch^2-(x-gridpoint[,1])^2),gridpoint[,1]-obj$rsearch,gridpoint[,1]+obj$rsearch, add=T)
            }
          }
        }
        
        mypch<-mypch+1
      }
    
      names(ret$snb)<-ret$gridpoints
      invisible(ret)
    }
  }
  
