      SUBROUTINE KRGTIL(XSW,YSW,XNE,YNE,ANGLE,NX,NY,NZ,NTX,NTY,NT,
     .                  DX,DY,ITX,ITY,IPT,XG,YG,ZG,VARG,DOG,
     .                  XGWORK,YGWORK,
     .                  LON,LAT,Z,EXTRAP,N,
     .                  COVTYPE,COVPAR,COVMAT,LDCOV,C0VEC,LDC0,COV0,
     .                  EXTCOV,TREND,NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,
     .                  FWORK,LDFWRK,F0WORK,DIST,INDSNB,INDSNA,INDSRT,
     .                  KWORK,NKWORK,RHSWORK,IPIV,MODE,MU,LAMBDA,LDLMBD,
     .                  X0,Y0,Z0,DO0,inddo,VAR0,BITS,
     .                  IERR)

      IMPLICIT NONE
      INTEGER NX,NY,NZ,NTX,NTY,NT,ITX,ITY,N,COVTYPE,TREND,NTREND,
     .        NSEARCH,NSMIN,NSMAX,MODE,IERR,INDSNB(*),INDSNA(*),EXTCOV,
     .        INDSRT(*),IPIV(*),IPT,EXTRAP,DOG(NX,*),DO0(*),inddo(*),
     .        LDCOV,LDC0,LDFWRK,LDLMBD,NKWORK,BITS(*)
      DOUBLE PRECISION XSW,YSW,XNE,YNE,ANGLE,DX,DY,
     .                 XG(*),YG(*),ZG(NX,*),VARG(NX,*),
     .                 LON(*),LAT(*),Z(*),COVMAT(LDCOV,*),C0VEC(LDC0,*),
     .                 COV0,RSEARCH,FWORK(LDFWRK,*),
     .                 F0WORK(NTREND,*),DIST(*),KWORK(NKWORK,*),
     .                 RHSWORK(NKWORK,*),MU(NTREND,*),LAMBDA(LDLMBD,*),
     .                 X0(*),Y0(*),Z0(*),VAR0(*),
     .                 XGWORK(NX,*),YGWORK(NX,*),COVPAR(*) 

c     subroutine for kriging prediction on tiles of a grid
c     
c     This subroutine takes the grid specification, forms tiles
c     (i.e. rectangular subregions of the grid) and calls KRIGE
c     (see below) on these tiles. The idea is to reduce computational
c     burden by collecting some neigbouring "krige"-systems and 
c     forming a combined krige system with multiple right hand sides
c     to be solved by DGESV simultaneously.
c
c
c     
c            [1,1]                              ne       
c              +-----------+-----------+-------+    
c              | o   o   o | o   o   o | o   o |      o    -- grid points (i,j)
c              |(1,1)      |           |    x  |    
c              | o   o   o | o   o   o | o   o |    +---+
c              |           |           |       |    | o |  -- grid tiles  [i,j]
c              | o   o   o | o   o   o | o   o |    +---+
c              +-----------+-----------+-------+
c            1 | o   o   o | o   o   o | o   o |      x    -- user specified
c              |           |           |       |              sw/ne corners
c       N   ...| o   o   o | o   o   o | o   o |__ 
c        +     |           |           |       |  > dy
c         \ ity| o   o   o | o   o   o | o   o |_/
c          \   +-----------+-----------+-------+
c           \  | o   o   o | o   o   o | o   o |     
c            \ |  x        |           |(ny,nx)|         
c             \| o   o   o | o   o   o | o   o |    
c              +-----------+-----------+-------+
c            sw  1  ... itx      \_ _/     [nty,ntx]
c                                  v
c                                   dx
c     parameters
c     XSW,YSW          lon/lat of sw-corner
c     XNE,YNE          lon/lat of ne-corner
c     ANGLE            angle to add to N-S 
c     NX,NY            no. of grid points in x / y direction (at least 2)
c     NZ               overall no of grid points (=NX*NY)
c     NTX,NTY          no. of tiles in x / y direction (at least 1)
c     NT               overall no of grid tiles (=NTX*NTY)
c     DX,DY            grid cell size
c     ITX,ITY          grid tile size (in no. of grid points per tile)
c     XG,YG,ZG,VARG    arrays to hold the output (grid coords. and 
c                      prediction)
c     DOG              0/1 array indicating for which points prediction
c                      is desired (can be e.g. a convex hull mask) 
c     LON,LAT,Z,N      data set
c     X0,Y0,Z0,VAR0,DO0 arrays to hold the input/output (grid coords. and 
c                      prediction) for one tile.
c     ...              ... other work arrays to pass through to KRIGE

      DOUBLE PRECISION COVFN
      EXTERNAL COVFN

      EXTERNAL KRIGE, MATPR

c     local variables
      INTEGER I,J,K,L,LIPT,IL,IU,JL,JU, tcnt,usesbbt
      DOUBLE PRECISION DELTA
      CHARACTER*16 NAME

c     constants
      integer dbglvl
      dbglvl=0

c     build/check grid and tile parameters:
      IF (NX*NY.NE.NZ) THEN
c          write(*,*) "wrong value of nz (should be nx*ny)"
         IERR=1
         RETURN
         END IF
      IF (NTX*NTY.NE.NT) THEN
c          write(*,*) "wrong value of nt (should be ntx*nty)"
         IERR=1
         RETURN
      END IF

c      IF (NX.GE.2 .AND. DX.EQ.0) THEN 
c         DX=(XNE-XSW)/(NX-1)
c         write (*,*)dy
c      ELSE IF (DX.GE.0) THEN
c         NX=AINT((XNE-XSW)/DX)+1
c         DELTA=XSW+NX*DX-XNE
c         XSW=XSW-DELTA/2
c         XNE=XNE+DELTA/2
c      ELSE
c         write(*,*) "wrong x dimension of grid"
c         IERR=1
c         RETURN
c      END IF
c
c      IF (NY.GE.2 .AND. DY.EQ.0) THEN 
c         DY=(YNE-YSW)/(NY-1)
c         WRITE (*,*)DY
c      ELSE IF (DY.GE.0) THEN
c         NY=AINT((YNE-YSW)/DY)+1
c         DELTA=YSW+NY*DY-YNE
c         YSW=YSW-DELTA/2
c         YNE=YNE+DELTA/2
c      ELSE
c         write(*,*) "wrong y dimension of grid"
c         IERR=1
c         RETURN
c      END IF

c      IF (NTX.GE.1) THEN 
c         ITX=INT(NX/NTX)+1
c      ELSE IF (ITX.GE.0) THEN
c         NTX=INT(NX/ITX)+1
c      ELSE
c         write(*,*) "wrong x dimension of tiles"
c         IERR=1
c         RETURN
c      END IF

c      IF (NTY.GE.1) THEN 
c         ITY=INT(NY/NTY)+1
c      ELSE IF (ITY.GE.0) THEN
c         NTY=INT(NY/ITY)+1
c      ELSE
c         write(*,*) "wrong y dimension of tiles"
c         IERR=1
c         RETURN
c      END IF

      DO 1 I=1,NY
         YG(I)=YSW+DY*(I-1)
 1    CONTINUE
      DO 2 J=1,NX
         XG(J)=XSW+DX*(J-1)
 2    CONTINUE
c      name="xg"
c      call matpr(xg,nx,1,nx,name,dbglvl)
c      name="yg"
c      call matpr(yg,ny,1,ny,name,dbglvl)

      DO 4 I=1,NX
         DO 3 J=1,NY
            YGWORK(I,J)=YG(J)
            XGWORK(I,J)=XG(I)
 3       CONTINUE
 4    CONTINUE
c      name="xgwork"
c      call matpr(xgwork,nx,ny,nx,name,dbglvl)
c      name="ygwork"
c      call matpr(ygwork,nx,ny,nx,name,dbglvl)

c     prepare the covariance matrix
      IF (EXTCOV.NE.1) THEN
         DO 1000 I=1,N
            DO 1001 J=I,N
               COVMAT(I,J)=COVFN(COVTYPE,COVPAR,
     .                        SQRT((LON(I)-LON(J))*(LON(I)-LON(J))+
     .                             (LAT(I)-LAT(J))*(LAT(I)-LAT(J))))
               COVMAT(J,I)=COVMAT(I,J)
 1001       CONTINUE
 1000    CONTINUE
      END IF
c     rotation:
c     call drotg(nz,xgwork,1,ygwork,1,COS(ALPHA),SIN(ALPHA))
c     loop over all tiles and pass them into KRIGE:
      if (bits(1+nz).ne.0) then
         usesbbt=1 
      end if
      TCNT=0
      DO 20 I=1,NTX
         DO 10 J=1,NTY
            TCNT=TCNT+1
c           determine tile corners:            
            IL=(I-1)*ITX+1
            IU=MIN(I*ITX,NX)
            JL=(J-1)*ITY+1
            JU=MIN(J*ITY,NY)
            LIPT=(IU-IL+1)*(JU-JL+1)

            do 7777 k=1,ITX
               do 8888 l=1,ITY
                  BITS((k+il-1) + (NY)*(l+jl-2) ) = TCNT
 8888          continue
 7777       continue

            do 111 k=1,LIPT
               z0(k)=0.0d0
               var0(k)=0.0d0
 111        continue
c           fill work arrays with current tile data:  


            CALL DSUBMV(XGWORK,NX,NY,IL,JL,IU,JU,NX,X0,1)
            CALL DSUBMV(YGWORK,NX,NY,IL,JL,IU,JU,NX,Y0,1)
            CALL ISUBMV(DOG,NX,NY,IL,JL,IU,JU,NX,DO0,1)
c            write(*,*)"tile",tcnt,":",il,jl,iu,ju," at ",x0(1)," - ",
c     .                  y0(1)

c            name="x0"
c            call matpr(x0,lipt,1,ipt,name,dbglvl)
c            name="y0"
c            call matpr(y0,lipt,1,ipt,name,dbglvl)

c           the main work now is done be KRIGE:
            CALL KRIGE(X0,Y0,DO0,INDDO,LIPT,LON,LAT,Z,N,
     .                 COVTYPE,COVPAR,COVMAT,LDCOV,C0VEC,LDC0,COV0,
     .                 TREND,NTREND,RSEARCH,NSEARCH,NSMIN,NSMAX,FWORK,
     .                 LDFWRK,F0WORK,NTREND,
     .                 DIST,INDSNB,INDSNA,INDSRT,KWORK,
     .                 NKWORK,RHSWORK,IPIV,MODE,MU,Z0,LAMBDA,LDLMBD,
     .                 VAR0,BITS(nz+2+(tcnt-1)*n),usesbbt,IERR)

c            if (usesbbt.ne.0) bits(nz+1)=TCNT

c            name="xg"
c            call matpr(xg,nx,1,nx,name,dbglvl)
c            name="yg"
c            call matpr(yg,ny,1,ny,name,dbglvl)
c           extract results for this tile
            IF (IERR.NE.0) THEN
               CALL ISUBMV(DOG,NX,NX,IL,JL,IU,JU,NX,DO0,-1)
               write(*,*)"error"
            ELSE
               CALL DSUBMV(ZG,NX,NX,IL,JL,IU,JU,NX,Z0,-1)
               CALL DSUBMV(VARG,NX,NY,IL,JL,IU,JU,NX,VAR0,-1)
            END IF

 10      CONTINUE
 20   CONTINUE


      RETURN
      END
