      SUBROUTINE DESIGN(LON,LAT,N,INDSNB,NS,
     .                  LON0,LAT0,N0,INDDO,NDO,
     .                  FWORK,LDFWRK,F0WORK,LDF0WK,NTREND,TREND,
     .                  IERR)

      IMPLICIT NONE
      INTEGER N,N0,NDO,NTREND,TREND,IERR,INDSNB(*),INDDO(*),
     .        LDFWRK,LDF0WK,NS
      DOUBLE PRECISION LAT0(*),LON0(*),LAT(*),LON(*),
     .                 FWORK(LDFWRK,*),F0WORK(LDF0WK,*)

c     Build a design matrix F and an accompanion f_0 vector (or multiple 
c     vectors)
c

      INTEGER I

      IF ((TREND.EQ.0 .AND. NTREND.NE.1) .OR.
     .    (TREND.EQ.1 .AND. NTREND.NE.3) .OR.
     .    (TREND.EQ.2 .AND. NTREND.NE.6)) THEN
         IERR=1
         RETURN
      END IF
            
      DO 10 I=1,NS
         IF (TREND.GE.0) THEN
            FWORK(I,1)=1
         END IF
         IF (TREND.GE.1) THEN
            FWORK(I,2)=LON(INDSNB(I))
            FWORK(I,3)=LAT(INDSNB(I))
         END IF
         IF (TREND.GE.2) THEN
            FWORK(I,4)=LON(INDSNB(I))*LON(INDSNB(I))
            FWORK(I,5)=LAT(INDSNB(I))*LAT(INDSNB(I))
            FWORK(I,6)=LAT(INDSNB(I))*LON(INDSNB(I))
         END IF
 10   CONTINUE
      DO 20 I=1,N0
      IF (TREND.GE.0) THEN
         F0WORK(1,I)=1
      END IF
      IF (TREND.GE.1) THEN
         F0WORK(2,I)=LON0(INDDO(I))
         F0WORK(3,I)=LAT0(INDDO(I))
      END IF
      IF (TREND.GE.2) THEN
         F0WORK(4,I)=LON0(INDDO(I))*LON0(INDDO(I))
         F0WORK(5,I)=LAT0(INDDO(I))*LAT0(INDDO(I))
         F0WORK(6,I)=LAT0(INDDO(I))*LON0(INDDO(I))
      END IF
 20   CONTINUE
      IERR=0
      RETURN
      END
