\name{plot.krige.map}
\alias{plot.krige.map}
\title{ Plot function for kriging objects }
\description{
  Plots selected output from a kriging object. 
}
\usage{
plot.krige.map(obj, show.data=TRUE, show.snb=FALSE,
               snb.i=NULL, snb.j=NULL, var=FALSE, nlevels=12)
}
\arguments{
  \item{obj}{ object of class \code{\link{krige.map}} }
  \item{show.data}{ logical, indicates if additional overlay plot of
    data points is wanted.}
  \item{show.snb}{ logical, indicates whether or not to
  \code{\link[base]{identify}} kriging grid points and their search
  neighbourhood.}
  \item{snb.i}{vector containing row indices (=x) of grid points for
    \code{show.snb}. If not given, \code{\link[base]{identify}} will be
    used to interactively select grid points.}
  \item{snb.j}{see \code{snb.i}, column index, y.}
  \item{var}{ plot kriging variance instead of predictions (if available). }
  \item{nlevels}{ number of contour levels }
}
\details{
  This plot gives an \code{\link{image}} overlayed with a
  \code{\link{contour}} plot of the prediction (or variance if
  \code{var=TRUE} is given). It places colored (same colors as used in
  the \code{image}) boxes for the data points over the plot.

  Optionally you can click on some grid point(s) to let the plot
  function generate a visualization of the according search
  neighbourhood, drawn as convex hull around the appropriate data points.
}
\value{
  If \code{show.snb=TRUE} was given, an (invisible) list with components
  \item{gridpoints }{indices of identified grid points, see above.}
  \item{snb }{list with collections of saerch neighbourhood indices
    according to the points in \code{$gridpoints}}
  is returned.
}
\references{ ftp://ftp-stat.uni-klu.ac.at/pub/R/contrib }
\author{ A. Gebhardt <albrecht.gebhardt@uni-klu.ac.at> }

\seealso{ \code{\link{krige.grid}},  \code{\link{krige.tiles}}, \code{\link{krige.map}} }

\examples{
\testonly{
# prepare variables from other example pages if they are not already there:
if(length(ls(pat="maas.kgrid"))==0){example(krige.grid)}
}
plot(maas.kgrid,show.snb=TRUE,snb.i=50,snb.j=50)
}
\keyword{ rgeostat }
