#include "krige_grid.h"


void krige_grid(double *xsw,
	    double *ysw,
            double *xne,
	    double *yne,
            double *angle,
	    int *nx,
	    int *ny,                 
	    //                  nz=as.integer(nz),                 
	    double *dx,
	    double *dy,
	    double *xg,
            double *yg,
	    double *zg,
	    double *varg,
	    int *dog,
	    double *lon,
	    double *lat,
	    double *z,
	    int *extrap,
	    int *n,
	    int *covtype,
	    double *covpar,
	    //	    double *covmat=as.double(covmat),
            //      ldcov=as.integer(n),
            //      c0vec=double(n),
            //      ldc0vec=as.integer(n),
	    //       double *cov0,
            //      extcov=as.integer(0), # no external cov matrix
            int *trend,
	    int *ntrend,
	    double *rsearch,
	    int *nsearch,
	    int *nsmin,
	    int *nsmax,
            //      fwork=double(n*ntrend),
            //      ldfwrk=as.integer(n),
            //      f0work=double(ntrend),
            //      dist=double(n),
            //      indsnb=integer(n),
            //      indsna=integer(n),
            //      indsrt=integer(n),
            //      kwork=double((n+ntrend)*(n+ntrend)),
            //      nkwork=as.integer(n+ntrend),
            //      rhswork=double(n+ntrend),
            //      ipiv=integer(n+ntrend),
	    int *mode,
	    // mu=double(ntrend),
            //      lambda=double(n),
            //      ldlmbd=as.integer(n),
            int *bits,
	    int *ierr){

    int nz=(*nx)*(*ny), ldcov=(*n), ldc0=(*n), extcov=0,
	ldfwrk=(*n), ldlmbd=(*n), nkwork=(*n+*ntrend);
    double *covmat, *c0vec, *fwork, *f0work, *dist, *kwork,
	   *rhswork, *mu, *lambda, cov0;
    int *indsnb, *indsna, *indsrt, *ipiv;

#ifndef TRANSIENT
    covmat=Calloc((size_t)(*n)*(*n),double);
    c0vec=Calloc((size_t)(*n),double);    
    fwork=Calloc((size_t)(*n)*(*ntrend),double);    
    f0work=Calloc((size_t)(*ntrend),double);    
    dist=Calloc((size_t)(*n),double);    
    indsnb=Calloc((size_t)(*n),int);    
    indsna=Calloc((size_t)(*n),int);    
    indsrt=Calloc((size_t)(*n),int); 
    kwork=Calloc((size_t)(*n+*ntrend)*(*n+*ntrend),double); 
    rhswork=Calloc((size_t)(*n+*ntrend),double);
    ipiv=Calloc((size_t)(*n+*ntrend),int);
    mu=Calloc((size_t)(*ntrend),double);
    lambda=Calloc((size_t)(*n),double); 
#else
    covmat=(double *) R_alloc((*n)*(*n),sizeof(double));
    c0vec=(double *) R_alloc((*n),sizeof(double));
    fwork=(double *) R_alloc((*n)*(*ntrend),sizeof(double));    
    f0work=(double *) R_alloc((*ntrend),sizeof(double));    
    dist=(double *) R_alloc((*n),sizeof(double));
    indsnb=(int *) R_alloc((*n),sizeof(int));
    indsna=(int *) R_alloc((*n),sizeof(int));
    indsrt=(int *) R_alloc((*n),sizeof(int));
    kwork=(double *) R_alloc((*n+*ntrend)*(*n+*ntrend),sizeof(double)); 
    rhswork=(double *) R_alloc((*n+*ntrend),sizeof(double)); 
    ipiv=(int *) R_alloc((*n+*ntrend),sizeof(int)); 
    mu=(double *) R_alloc((*ntrend),sizeof(double));
    lambda=(double *) R_alloc((*n),sizeof(double));
#endif

    
    F77_CALL(krggrd)(xsw, 
		     ysw, 
		     xne, 
		     yne, 
		     angle, 
		     nx, 
		     ny, 
		     &nz, 
		     dx, 
		     dy, 
		     xg, 
		     yg, 
		     zg, 
		     varg, 
		     dog, 
		     lon, 
		     lat, 
		     z, 
		     extrap, 
		     n, 
		     covtype, 
		     covpar, 
		     covmat, 
		     &ldcov, 
		     c0vec, 
		     &ldc0, 
		     &cov0, 
		     &extcov, 
		     trend, 
		     ntrend, 
		     rsearch, 
		     nsearch, 
		     nsmin, 
		     nsmax, 
		     fwork, 
		     &ldfwrk, 
		     f0work, 
		     dist, 
		     indsnb, 
		     indsna, 
		     indsrt, 
		     kwork, 
		     &nkwork, 
		     rhswork, 
		     ipiv, 
		     mode, 
		     mu, 
		     lambda, 
		     &ldlmbd, 
		     bits, 
		     ierr);
    

#ifndef TRANSIENT
    Free(lambda);
    Free(mu);
    Free(ipiv);
    Free(rhswork);
    Free(kwork);
    Free(indsrt);
    Free(indsna);
    Free(indsnb);
    Free(dist);
    Free(f0work);
    Free(fwork);
    Free(c0vec);
    Free(covmat);
#endif
    
}
