krige.grid <- function(point.obj,
                       at,
                       var.mod.obj,
                       xsw = NULL, ysw = NULL, xne = NULL, yne = NULL,
                       dx = NULL, dy = NULL, nx = NULL, ny = NULL,
                       angle   = NULL,
                       maxdist = NULL,
                       extrap  = FALSE,
                       border  = NULL,
                       trend   = 0,
                       rsearch = 0,
                       nsearch = 0,
                       nsmin   = -1,
                       nsmax   = -1,
                       mode    = 3,
                       duplicate = "error",
                       dupfun = NULL)
  {
    if(is.null(angle)) angle<-0
    
    if(is.null(xsw)) xsw<-min(point.obj$x)
    if(is.null(xne)) xne<-max(point.obj$x)
    if(is.null(ysw)) ysw<-min(point.obj$y)
    if(is.null(yne)) yne<-max(point.obj$y)

    dgx <- xne-xsw
    dgy <- yne-ysw

    if(is.null(nx)){
      if(is.null(dx)) dx <- dgx/20
      
      nx <- ceiling(dgx/dx)+1
    } else {
      if(!is.null(dx))
        stop("either \"dx\" or \"nx\" should be given!")
      if(nx==0)
        stop("\"dx\" cannot be 0!")
      
      dx <- dgx/nx
        
    }
    if(is.null(ny)){
      if(is.null(dy)) dy <- dgy/20
      
      ny <- ceiling(dgy/dy)+1
    } else {
      if(!is.null(dy))
        stop("either \"dy\" or \"ny\" should be given!")
      if(ny==0)
        stop("\"dy\" cannot be 0!")
      
      dy <- dgy/ny
        
    }
    oldat<-at
    at <- point.obj[[match(at, names(point.obj))]]
    n <- length(point.obj$x)
    nz <- nx * ny

    # eliminate duplicates:
    xy <- paste(point.obj$x, point.obj$y, sep =",")
    idup <- match(xy, xy)
    if(duplicate=="user" && !is.function(dupfun))
      stop("duplicate=\"user\" requires dupfun to be set to a function")
    if(duplicate!="error")
      {
        centre <- function(x) {
          switch(duplicate,
                 mean = mean(x),
                 median = median(x),
                 user = dupfun(x))
        }
        if(duplicate!="strip"){
          at <- unlist(lapply(split(at,idup), centre))
          ord <- !duplicated(xy)
          point.obj$x <- point.obj$x[ord]
          point.obj$y <- point.obj$y[ord]
          n <- length(point.obj$x)
        }
      else{
        ord <- (hist(idup,plot=F,freq=T,breaks=seq(0.5,max(idup)+0.5,1))$counts==1)
        point.obj$x <- point.obj$x[ord]
        point.obj$y <- point.obj$y[ord]
        at <- at[ord]
        n <- length(point.obj$x)
      }
      }
    else
      if(any(duplicated(xy)))
        stop("duplicate data points")
    
    dog <- matrix(1, nx, ny)
    if (!extrap) {
      tmpgrd <- cbind(rep(seq(xsw,xne,length=nx),ny),sort(rep(seq(ysw,yne,length=ny),nx)))
      if(is.null(border))
        dog <- in.chull(tmpgrd[,1], tmpgrd[,2],point.obj$x,point.obj$y)
      else {
        if(is.null(border$x) | is.null(border$y) | length(border$x)!=length(border$y))
          stop("border argument wrong!")
        dog <- in.polygon(tmpgrd[,1], tmpgrd[,2], border$x,border$y)
      }
      # workaround for int <-> unsigned int problem on alpha platform:
      dog <- abs(as.numeric(dog))
      dog <- matrix(dog, nx, ny,byrow=F)
    }
    
    extrap<-1*extrap

    if(!is.null(maxdist))rsearch<-maxdist
    
    if (!inherits(point.obj, "point")) 
      stop("point.obj must be of class, \"point\".\n")
    if (!inherits(var.mod.obj, "variogram.model")) 
      stop("var.mod.obj must be of class, \"variogram.model\".\n")
    if(mode==1 && length(at)!=n) stop("length of x and z differ\n")
    if(rsearch>0 & nsearch>0)
      stop("specify only one of rsearch and nsearch\n")
    if(nsmin>nsmax)
      stop("nsmin>nsmax\n")
#    if(rsearch>0){
#      if(nsmin==0) nsmin<-ceiling(n*0.1)
#      if(nsmax==0) nsmax<-ceiling(n*0.9)
#    }
    if(trend==0) ntrend<-1
    if(trend==1) ntrend<-3
    if(trend==2) ntrend<-6

    covtype<-switch(attr(var.mod.obj,"type"),
                    exponential=1,
                    gaussian=2,
                    spherical=3,
                    linear=4,
                    0)
    c0<-0
    covmat<-matrix(0,n,n)

    snbbit<-rep(0,1+n*nz)
    snbbit[1]<-1
    
    ans<-.Fortran("krggrd",
                  xsw=as.double(xsw),
                  ysw=as.double(ysw),                 
                  xne=as.double(xne),                 
                  yne=as.double(yne),                 
                  angle=as.double(angle),                 
                  nx=as.integer(nx),                 
                  ny=as.integer(ny),                 
                  nz=as.integer(nz),                 
                  dx=as.double(dx),                 
                  dy=as.double(dy),                 
                  xg=double(nx),                 
                  yg=double(ny),                 
                  zg=double(nz),
                  varg=double(nz),
                  dog=as.integer(dog),
                  lon=as.double(point.obj$x),
                  lat=as.double(point.obj$y),
                  z=as.double(at),
                  extrap=as.integer(extrap),
                  n=as.integer(n),
                  covtype=as.integer(covtype),
                  covpar=as.double(var.mod.obj$parameters),
                  covmat=as.double(covmat),
                  ldcov=as.integer(n),
                  c0vec=double(n),
                  ldc0=as.integer(n),
                  c0=as.double(c0),
                  extcov=as.integer(0), # no external cov matrix
                  trend=as.integer(trend),
                  ntrend=as.integer(ntrend),
                  rsearch=as.double(rsearch),
                  nsearch=as.integer(nsearch),
                  nsmin=as.integer(nsmin),
                  nsmax=as.integer(nsmax),
                  fwork=double(n*ntrend),
                  ldfwrk=as.integer(n),
                  f0work=double(ntrend),
                  dist=double(n),
                  indsnb=integer(n),
                  indsna=integer(n),
                  indsrt=integer(n),
                  kwork=double((n+ntrend)*(n+ntrend)),
                  nkwork=as.integer(n+ntrend),
                  rhswork=double(n+ntrend),
                  ipiv=integer(n+ntrend),
                  mode=as.integer(mode),
                  mu=double(ntrend),
                  lambda=double(n),
                  ldlmbd=as.integer(n),
                  bits=as.integer(c(integer(nz),snbbit)),
                  ierr=integer(1),
                  .Package="rgeostat")
    
#    ans<-krige.solve(s$x,s$y,point.obj$x,point.obj$y,
#                     at,covmat,c0vec,c0,trend,rsearch,nsmin,nsmax,mode)


    
    retval<-list(x=ans$xg,
                 y=ans$yg,
                 z=matrix(ans$zg,nx,ny),
                 var=matrix(ans$varg,nx,ny),
                 done=matrix(ans$dog, nx, ny, byrow = F),
                 snb=matrix(ans$bits[(nz+2):(nz+n*nz+1)],nrow=n,ncol=nz,byrow=F))
    retval$z[retval$done<=0] <- NA
    retval$var[retval$done<=0] <- NA
    retval$data<-point.obj
    retval$at<-oldat
    class(retval)<-"krige.map"
    retval    
  }

krige.grid.c <- function(point.obj,
                       at,
                       var.mod.obj,
                       xsw = NULL, ysw = NULL, xne = NULL, yne = NULL,
                       dx = NULL, dy = NULL, nx = NULL, ny = NULL,
                       angle   = NULL,
                       maxdist = NULL,
                       extrap  = FALSE,
                       border  = NULL,
                       trend   = 0,
                       rsearch = 0,
                       nsearch = 0,
                       nsmin   = -1,
                       nsmax   = -1,
                       mode    = 3,
                       duplicate = "error",
                       dupfun = NULL)
  {
    if(is.null(angle)) angle<-0
    
    if(is.null(xsw)) xsw<-min(point.obj$x)
    if(is.null(xne)) xne<-max(point.obj$x)
    if(is.null(ysw)) ysw<-min(point.obj$y)
    if(is.null(yne)) yne<-max(point.obj$y)

    dgx <- xne-xsw
    dgy <- yne-ysw

    if(is.null(nx)){
      if(is.null(dx)) dx <- dgx/20
      
      nx <- ceiling(dgx/dx)+1
    } else {
      if(!is.null(dx))
        stop("either \"dx\" or \"nx\" should be given!")
      if(nx==0)
        stop("\"dx\" cannot be 0!")
      
      dx <- dgx/nx
        
    }
    if(is.null(ny)){
      if(is.null(dy)) dy <- dgy/20
      
      ny <- ceiling(dgy/dy)+1
    } else {
      if(!is.null(dy))
        stop("either \"dy\" or \"ny\" should be given!")
      if(ny==0)
        stop("\"dy\" cannot be 0!")
      
      dy <- dgy/ny
        
    }
    oldat<-at
    at <- point.obj[[match(at, names(point.obj))]]
    n <- length(point.obj$x)
    nz <- nx * ny

    # eliminate duplicates:
    xy <- paste(point.obj$x, point.obj$y, sep =",")
    idup <- match(xy, xy)
    if(duplicate=="user" && !is.function(dupfun))
      stop("duplicate=\"user\" requires dupfun to be set to a function")
    if(duplicate!="error")
      {
        centre <- function(x) {
          switch(duplicate,
                 mean = mean(x),
                 median = median(x),
                 user = dupfun(x))
        }
        if(duplicate!="strip"){
          at <- unlist(lapply(split(at,idup), centre))
          ord <- !duplicated(xy)
          point.obj$x <- point.obj$x[ord]
          point.obj$y <- point.obj$y[ord]
          n <- length(point.obj$x)
        }
      else{
        ord <- (hist(idup,plot=F,freq=T,breaks=seq(0.5,max(idup)+0.5,1))$counts==1)
        point.obj$x <- point.obj$x[ord]
        point.obj$y <- point.obj$y[ord]
        at <- at[ord]
        n <- length(point.obj$x)
      }
      }
    else
      if(any(duplicated(xy)))
        stop("duplicate data points")
    
    dog <- matrix(1, nx, ny)
    if (!extrap) {
      tmpgrd <- cbind(rep(seq(xsw,xne,length=nx),ny),sort(rep(seq(ysw,yne,length=ny),nx)))
      if(is.null(border))
        dog <- in.chull(tmpgrd[,1], tmpgrd[,2],point.obj$x,point.obj$y)
      else {
        if(is.null(border$x) | is.null(border$y) | length(border$x)!=length(border$y))
          stop("border argument wrong!")
        dog <- in.polygon(tmpgrd[,1], tmpgrd[,2], border$x,border$y)
      }
      # workaround for int <-> unsigned int problem on alpha platform:
      dog <- abs(as.numeric(dog))
      dog <- matrix(dog, nx, ny,byrow=F)
    }
    
    extrap<-1*extrap

    if(!is.null(maxdist))rsearch<-maxdist
    
    if (!inherits(point.obj, "point")) 
      stop("point.obj must be of class, \"point\".\n")
    if (!inherits(var.mod.obj, "variogram.model")) 
      stop("var.mod.obj must be of class, \"variogram.model\".\n")
    if(mode==1 && length(at)!=n) stop("length of x and z differ\n")
    if(rsearch>0 & nsearch>0)
      stop("specify only one of rsearch and nsearch\n")
    if(nsmin>nsmax)
      stop("nsmin>nsmax\n")
#    if(rsearch>0){
#      if(nsmin==0) nsmin<-ceiling(n*0.1)
#      if(nsmax==0) nsmax<-ceiling(n*0.9)
#    }
    if(trend==0) ntrend<-1
    if(trend==1) ntrend<-3
    if(trend==2) ntrend<-6

    covtype<-switch(attr(var.mod.obj,"type"),
                    exponential=1,
                    gaussian=2,
                    spherical=3,
                    linear=4,
                    0)
    c0<-0
    covmat<-matrix(0,n,n)

    snbbit<-rep(0,1+n*nz)
    snbbit[1]<-1
    
    ans<-.C("krige_grid",
                  xsw=as.double(xsw),
                  ysw=as.double(ysw),                 
                  xne=as.double(xne),                 
                  yne=as.double(yne),                 
                  angle=as.double(angle),                 
                  nx=as.integer(nx),                 
                  ny=as.integer(ny),                 
                 # nz=as.integer(nz),                 
                  dx=as.double(dx),                 
                  dy=as.double(dy),                 
                  xg=double(nx),                 
                  yg=double(ny),                 
                  zg=double(nz),
                  varg=double(nz),
                  dog=as.integer(dog),
                  lon=as.double(point.obj$x),
                  lat=as.double(point.obj$y),
                  z=as.double(at),
                  extrap=as.integer(extrap),
                  n=as.integer(n),
                  covtype=as.integer(covtype),
                  covpar=as.double(var.mod.obj$parameters),
                 # covmat=as.double(covmat),
                 # ldcov=as.integer(n),
                 # c0vec=double(n),
                 # ldc0=as.integer(n),
                 #  cov0=as.double(cov0),
                 # extcov=as.integer(0), # no external cov matrix
                  trend=as.integer(trend),
                  ntrend=as.integer(ntrend),
                  rsearch=as.double(rsearch),
                  nsearch=as.integer(nsearch),
                  nsmin=as.integer(nsmin),
                  nsmax=as.integer(nsmax),
                 # fwork=double(n*ntrend),
                 # ldfwrk=as.integer(n),
                 # f0work=double(ntrend),
                 # dist=double(n),
                 # indsnb=integer(n),
                 # indsna=integer(n),
                 # indsrt=integer(n),
                 # kwork=double((n+ntrend)*(n+ntrend)),
                 # nkwork=as.integer(n+ntrend),
                 # rhswork=double(n+ntrend),
                 # ipiv=integer(n+ntrend),
                  mode=as.integer(mode),
                 # mu=double(ntrend),
                 # lambda=double(n),
                 # ldlmbd=as.integer(n),
                  bits=as.integer(c(integer(nz),snbbit)),
                  ierr=integer(1),
                  .Package="rgeostat")
    
#    ans<-krige.solve(s$x,s$y,point.obj$x,point.obj$y,
#                     at,covmat,c0vec,c0,trend,rsearch,nsmin,nsmax,mode)


    
    retval<-list(x=ans$xg,
                 y=ans$yg,
                 z=matrix(ans$zg,nx,ny),
                 var=matrix(ans$varg,nx,ny),
                 done=matrix(ans$dog, nx, ny, byrow = F),
                 snb=matrix(ans$bits[(nz+2):(nz+n*nz+1)],nrow=n,ncol=nz,byrow=F))
    retval$z[retval$done<=0] <- NA
    retval$var[retval$done<=0] <- NA
    retval$data<-point.obj
    retval$at<-oldat
    class(retval)<-"krige.map"
    retval    
  }

