#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <syslog.h>
#include <strings.h>
#include "pvmstuff.h"
#include "inet.h"
#include "srv_socket.h"
#include "pvm_error.h"
#include <netdb.h>
#include "pvm_debug.h"
#include "tmeasure.h"
#include <sys/socket.h>

#define TEST_NULL(memory,msg) \
  if (memory==NULL) { \
    syslog(LOG_WARNING,msg); \
    closelog(); \
    exit(EXIT_FAILURE); \
  }


int main(void) {
  int retval,line,col;  
  struct servent *sp;
  syncmsg okmsg;
  size_msg param_size;
  static_msg param;
  double *lon,*lat,*z,*xgwork,*ygwork, *zg, *varg;
  int *dog, *gridcnt;

 
  struct sockaddr his_addr;
  char *hostname;
  int addrlen;

#ifdef LOG_STATISTIC
#ifdef USE_RDTSC
  unsigned long long int start,end;
#else
  time_t start,end;
#endif
#endif

#ifndef START_WITH_INETD
  int listenfd, connfd,n;
#if defined(sun) | defined(__osf__)
  int
#else
  socklen_t 
#endif
  len;
  struct sockaddr_in servaddr, cliaddr;
  char buff[100];
#endif

  openlog("pvm_server",LOG_PID|LOG_ODELAY,LOG_DAEMON);
  __SET_DEBUG_FILE("/tmp/pvm_server.txt");
  __DEBUG1("Pvm_server started!\nReady to run...\n");

#ifdef START_WITH_INETD
  /*
   inetd gave us the connection to our client
   0, 1 and 2 is reserved!
   (0 - stdin, 1 - stdout, 2 - stderr)
   we do not need to do the whole listen etc. stuff
  */ 
  fd_in=0;
  fd_out=1;
#else
  __DEBUG1("Waiting for connection!\n");
  // do everything by hand
  if ((listenfd=socket(AF_INET,SOCK_STREAM,0))<0) {
    syslog(LOG_WARNING,"Can't open stream socket");
    closelog();
    exit(EXIT_FAILURE);
  }

 // determine port to use
  sp=getservbyname(PVMKRIGE_PORT_NAME,"tcp");

  if (sp==NULL) {
    syslog(LOG_WARNING,"Unable to determine port number!\n");
    closelog();
    exit(EXIT_FAILURE);  
  }
  
  
  bzero((char*)&servaddr, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servaddr.sin_port=htons(sp->s_port);
  
  if ((bind(listenfd, (struct sockaddr *) &servaddr,sizeof(servaddr))) < 0) {
    syslog(LOG_WARNING,"<bind> failed!");
    closelog();
    exit(EXIT_FAILURE);
  }
  
  if ((listen(listenfd,1))<0) {
    syslog(LOG_WARNING,"<listen> failed!");
    closelog();
    exit(EXIT_FAILURE);
  }
  
  len=sizeof(cliaddr);
  if ((fd_in=accept(listenfd,(struct sockaddr *)&cliaddr,&len)) < 0) {
    syslog(LOG_WARNING,"<accept> failed");
    closelog();
    exit(EXIT_FAILURE);
  }

  fd_out=fd_in;  
#endif // START_WITH_INETD

// determine start time
#ifdef LOG_STATISTIC
#ifdef USE_RDTSC 
  start=rdtsc();
#else
  start=time(NULL);
#endif
#endif
  __DEBUG1("Got connection to R!\n");

  // start communication with R 
  // sort of handshake            
  retval=readn(fd_in,(char*)&okmsg,sizeof(syncmsg));
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Read ok msg failed");	
    closelog();
    exit(EXIT_FAILURE);
  }
  retval=writen(fd_out,(char*)&okmsg,sizeof(syncmsg));
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Write ok msg failed!");	
    closelog();
    exit(EXIT_FAILURE);
  }
 
  // ------------------------------------------------------------
 
  // get information about parameter settings
  __DEBUG1("Reading datasize\n");
 
  retval=readn(fd_in,(char*)&param_size,sizeof(size_msg));  
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Failed to read data size");	
    closelog();
    exit(EXIT_FAILURE);
  }
  __DEBUG5("n %d, nx: %d, ny: %d, ntrend: %d\n",
	   param_size.n,param_size.nx,param_size.ny,param_size.ntrend);

  retval=writen(fd_out,(char*)&okmsg,sizeof(syncmsg));
  if (retval==FAILURE) {
	syslog(LOG_WARNING,"Failed to write syncmsg msg");	
	closelog();
  	exit(EXIT_FAILURE);
  }


  __DEBUG1("Reading static parameters (integer)\n");
 
  retval=readn(fd_in,(char*)&(param.i),sizeof(static_msg_i));  
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Failed to read static parameters (integer)");	
    closelog();
    exit(EXIT_FAILURE);
  }

  __DEBUG7("covtype %d, mode: %d, trend: %d, nsearch: %d, nsmin: %d, nsmax: %d\n",
	   param.i.covtype,param.i.mode,param.i.trend,param.i.nsearch,param.i.nsmin,param.i.nsmax);

  retval=writen(fd_out,(char*)&okmsg,sizeof(syncmsg));
  if (retval==FAILURE) {
	syslog(LOG_WARNING,"Failed to write syncmsg msg");	
	closelog();
  	exit(EXIT_FAILURE);
  }

  __DEBUG1("Reading static parameters (double)\n");
 
  retval=readn(fd_in,(char*)&(param.d),sizeof(static_msg_d));  
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Failed to read static parameters (double)");	
    closelog();
    exit(EXIT_FAILURE);
  }
  __DEBUG5("rsearch %f, nugget: %f, sill: %f, range: %f\n",
	   param.d.rsearch,param.d.nugget,param.d.sill,param.d.range);

  retval=writen(fd_out,(char*)&okmsg,sizeof(syncmsg));
  if (retval==FAILURE) {
	syslog(LOG_WARNING,"Failed to write syncmsg msg");	
	closelog();
  	exit(EXIT_FAILURE);
  }



  __DEBUG1("Ready to receive data\n");

  //  retval=large_get(sockfd,(double**) &A);
  // allocate memory 
  lon=(double*)malloc(param_size.n*sizeof(double));
  TEST_NULL(lon,"Memory allocation problem (lon)");
  lat=(double*)malloc(param_size.n*sizeof(double));
  TEST_NULL(lat,"Memory allocation problem (lat)");
  z=(double*)malloc(param_size.n*sizeof(double));
  TEST_NULL(z,"Memory allocation problem (z)");

  xgwork=(double*)malloc(param_size.nx*param_size.ny*sizeof(double));
  TEST_NULL(xgwork,"Memory allocation problem (xgwork)");
  ygwork=(double*)malloc(param_size.nx*param_size.ny*sizeof(double));
  TEST_NULL(ygwork,"Memory allocation problem (ygwork)");
  dog=(int*)malloc(param_size.nx*param_size.ny*sizeof(int));
  TEST_NULL(dog,"Memory allocation problem (dog)");

  zg=(double*)malloc(param_size.nx*param_size.ny*sizeof(double));
  TEST_NULL(zg,"Memory allocation problem (zg)");
  varg=(double*)malloc(param_size.nx*param_size.ny*sizeof(double));
  TEST_NULL(varg,"Memory allocation problem (varg)");
  gridcnt=(int*)malloc(param_size.nx*param_size.ny*sizeof(int));
  TEST_NULL(gridcnt,"Memory allocation problem (gridcnt)");


  // receive data
  recv_data(fd_in,lon,param_size.n*sizeof(double),"lon","Could not receive data correctly",
	    "No response from R-client after he sent lon!");
  recv_data(fd_in,lat,param_size.n*sizeof(double),"lat","Could not receive data correctly",
	    "No response from R-client after he sent lat!");
  recv_data(fd_in,z,param_size.n*sizeof(double),"z","Could not receive data correctly",
	    "No response from R-client after he sent z!");

  recv_data(fd_in,xgwork,param_size.nx*param_size.ny*sizeof(double),"xgwork",
	    "Could not receive data correctly",
	    "No response from R-client after he sent xgwork!");
  recv_data(fd_in,ygwork,param_size.nx*param_size.ny*sizeof(double),"ygwork",
	    "Could not receive data correctly",
	    "No response from R-client after he sent ygwork!");
  recv_data(fd_in,dog,param_size.nx*param_size.ny*sizeof(int),"dog",
	    "Could not receive data correctly",
	    "No response from R-client after he sent dog!");


  __DEBUG1("Going to start pvm...\n");
  pvm_krige_tiles(lon,lat,z,xgwork,ygwork,dog,param,param_size,zg,varg,gridcnt);



  // ------------------------------------------------------------

  __DEBUG1("pvm_krige finished!\n");

  // notify R that data is ready
  // send zg
  send_data(fd_out,zg,param_size.nx*param_size.ny*sizeof(double),"zg","Failed to send zg!","Failed to read syncmsg!");
 // send varg
  send_data(fd_out,varg,param_size.nx*param_size.ny*sizeof(double),"varg","Failed to send varg!","Failed to read syncmsg!");


  free(gridcnt);
  free(varg);
  free(zg);
  free(dog);
  free(ygwork);
  free(xgwork);
  free(z);
  free(lat);
  free(lon);

  closelog();
  exit(EXIT_SUCCESS);
}                                       
