#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "inet.h"
#include "socket.h"
#include "model.h" 
#include "pvm_debug.h" 
#include <R.h>
#include <Rinternals.h>

#define TEST_FAILURE(res,msg) \
  if (res==FAILURE) { \
    perror(msg); \
    close(sockfd); \
    goto finish; \
  }


void krige_pvm(double *xsw,
		  double *ysw,
		  double *xne,
		  double *yne,
		  double *angle,
		  int *nx,
		  int *nall,                 
		  double *dx,
		  double *dy,
		  int *iall,
		  double *xg,
		  double *yg,
		  double *zg,
		  double *varg,
		  int *dog,
		  double *lon,
		  double *lat,
		  double *z,
		  int *extrap,
		  int *n,
		  int *covtype,
		  double *covpar,
		  int *trend,
		  int *ntrend,
		  double *rsearch,
		  int *nsearch,
		  int *nsmin,
		  int *nsmax,
		  int *mode,
	       //                  int *bits,
	          int *ierr,
		  int *nxper,
		  int *nyper
		  ){
    
  int sockfd,retval;
  struct servent *sp;
  size_msg param_size;
  static_msg param;
  syncmsg okmsg; 
  struct sockaddr_in addr;
  int i,j;
  double *xgwork, *ygwork;
  int nz=(*nx)*(nall[0]), nt=((nall[1])*(nall[2]));

#ifdef TRANSIENT
  xgwork=Calloc((size_t)(nz),double);
  ygwork=Calloc((size_t)(nz),double); 
#else
  xgwork=(double *) R_alloc((nz),sizeof(double));
  ygwork=(double *) R_alloc((nz),sizeof(double)); 
#endif

  // hello msg
  okmsg.ok=1;

  // ------------------------------------------------------------
  // prepare parameters
  param_size.n=*n;
  param_size.nx=*nx;
  param_size.ny=nall[0];
  param_size.nt=nt;
  param_size.ntx=nall[1];
  param_size.nty=nall[2];
  param_size.itx=iall[0];
  param_size.ity=iall[1];
  param_size.nxper=*nxper;
  param_size.nyper=*nyper;
  param_size.ntrend=*ntrend;

  param.i.covtype=*covtype;
  param.i.mode=*mode;
  param.i.trend=*trend;
  param.i.nsearch=*nsearch;
  param.i.nsmin=*nsmin;
  param.i.nsmax=*nsmax;
  param.i.nxper=*nxper;
  param.i.nyper=*nyper;
  param.d.rsearch=*rsearch;
  param.d.nugget=covpar[0];
  param.d.sill=covpar[1];
  param.d.range=covpar[2];

   
  // determine port to use
  sp=getservbyname(PVMKRIGE_PORT_NAME,"tcp");

  if (sp==NULL) {
    perror("Unable to determine port number!\n");
    //exit(EXIT_FAILURE);
    goto finish;    
  }

  // address of the server we want to connect to
  // here the server resides at the same host as the client
  bzero((char*)&addr,sizeof(addr));
  addr.sin_family=AF_INET;
  addr.sin_addr.s_addr=htonl(INADDR_ANY);
  addr.sin_port=htons(sp->s_port);


  // create socket
  if ((sockfd=socket(AF_INET,SOCK_STREAM,0))<0)
  {
    perror("Can't open stream socket\n");
    //exit(EXIT_FAILURE);
    goto finish;
  }
 
  if (connect(sockfd,(struct sockaddr *) &addr,sizeof(addr))<0)
  {
    perror("Can't connect to serv.\n");
    printf("Errno: %d\n",errno);
    close(sockfd);
    //exit(EXIT_FAILURE);
    goto finish;
  }

  // handshake with server
  retval=writen(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,"Can not send ok msg to server! - handshake failed!\n");


  // wait for response from server
  retval=readn(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,"No response from server! - handshake failed!\n");
 

  // handshake finished - do some work!


  // ------------------------------------------------------------

  // send client information about the size of data
  __DEBUG1("Send info about datasize\n");

  retval=writen(sockfd,(char*)&param_size,sizeof(size_msg));
  TEST_FAILURE(retval,"Could not send data about datasize!\n");
 
  // server has received dimension data
  __DEBUG1("Server got parameter settings\n");

  retval=readn(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,"No response from server after he received dimension data!\n");

  // send static parameters (integer)
  __DEBUG1("Send static parameters (integer)\n");

  retval=writen(sockfd,(char*)&(param.i),sizeof(static_msg_i));
  TEST_FAILURE(retval,"Could not send data about datasize!\n");
 
  // server has received dimension data
  __DEBUG1("Server got parameter settings\n");

  retval=readn(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,"No response from server after he received dimension data!\n");

  // send static parameters (double)
  __DEBUG1("Send static parameters (double)\n");

  retval=writen(sockfd,(char*)&(param.d),sizeof(static_msg_d));
  TEST_FAILURE(retval,"Could not send data about datasize!\n");
 
  // server has received dimension data
  __DEBUG1("Server got parameter settings\n");

  retval=readn(sockfd,(char*)&okmsg,sizeof(syncmsg));
  TEST_FAILURE(retval,"No response from server after he received dimension data!\n");

  // send data
  send_data(sockfd,lon,*n*sizeof(double),"lon","Could not transmit data correctly",
	    "No response from server after he received lon!");
  send_data(sockfd,lat,*n*sizeof(double),"lat","Could not transmit data correctly",
	    "No response from server after he received lat!");
  send_data(sockfd,z,*n*sizeof(double),"z","Could not transmit data correctly",
	    "No response from server after he received z!");

  // calculate grid coordinates:
  for (i=0; i<*nx; i++)
      for (j=0; j<nall[0]; j++){
	  ygwork[j*(*nx)+i]=*ysw+*dy*j;
	  xgwork[j*(*nx)+i]=*xsw+*dx*i;
      }
  
  // send grid coordinates:
  send_data(sockfd,xgwork,nz*sizeof(double),"xgwork","Could not transmit data correctly",
	    "No response from server after he received xgwork!");
  send_data(sockfd,ygwork,nz*sizeof(double),"ygwork","Could not transmit data correctly",
	    "No response from server after he received ygwork!");

  send_data(sockfd,dog,nz*sizeof(int),"dog","Could not transmit data correctly",
	    "No response from server after he received dog!");

 

  // wait for results

   recv_data(sockfd,zg,param_size.nx*param_size.ny*sizeof(double),"zg","zg was not received properly!\n","Can not send ok msg to server!\n");
   recv_data(sockfd,varg,param_size.nx*param_size.ny*sizeof(double),"varg","varg was not received properly!\n","Can not send ok msg to server!\n");

  close(sockfd);       
  finish:

#ifdef TRANSIENT
  Free(ygwork);
  Free(xgwork);
#endif
}
