#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <syslog.h>
#include <strings.h>
#include "pvmstuff.h"
#include "inet.h"
#include "srv_socket.h"
#include "pvm_error.h"
#include <netdb.h>
#include "pvm_debug.h"
#include "tmeasure.h"
#include <sys/socket.h>

#define TEST_NULL(memory,msg) \
  if (memory==NULL) { \
    syslog(LOG_WARNING,msg); \
    closelog(); \
    exit(EXIT_FAILURE); \
  }


// len in bytes 
/*
void recv_data(void *buffer,int len,char *msg,char *err,char *err2) {
  int retval;
  syncmsg okmsg;
  okmsg.ok=1;

  __DEBUG2("Wait for <%s>\n",msg);

  //retval=large_send(sockfd,matrix,data_size);
  retval=readn(fd_in,(char*)buffer,len);
  if (retval==FAILURE){
    syslog(LOG_WARNING,"Read failed <%s>",err);
    closelog();
    exit(EXIT_FAILURE);
  }

  __DEBUG2("Sent <%s>\n",msg);

  retval=writen(fd_out,(char*)&okmsg,sizeof(syncmsg));
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Write failed <%s>",err2);
    closelog();
    exit(EXIT_FAILURE);
  }
}
*/


     
int main(void) {
  int retval,line,col;  
  struct servent *sp;
  syncmsg okmsg;
  message parameter;
  double *pointx,*pointy,*pointz;
  double *sx,*sy; 
  double *zhat,*sigma2hat;
  double *gmatrix_inv;
  double *gvector;
  double *dst;
  double *lambda_hat;
  double *sdo;
  struct sockaddr his_addr;
  char *hostname;
  int addrlen;

#ifdef LOG_STATISTIC
#ifdef USE_RDTSC
  unsigned long long int start,end;
#else
  time_t start,end;
#endif
#endif

#ifndef START_WITH_INETD
  int listenfd, connfd,n;
#if defined(sun) | defined(__osf__)
  int
#else
  socklen_t 
#endif
  len;
  struct sockaddr_in servaddr, cliaddr;
  char buff[100];
#endif

  openlog("pvm_server",LOG_PID|LOG_ODELAY,LOG_DAEMON);
  __SET_DEBUG_FILE("/tmp/pvm_server.txt");
  __DEBUG1("Pvm_server started!\nReady to run...\n");

#ifdef START_WITH_INETD
  /*
   inetd gave us the connection to our client
   0, 1 and 2 is reserved!
   (0 - stdin, 1 - stdout, 2 - stderr)
   we do not need to do the whole listen etc. stuff
  */ 
  fd_in=0;
  fd_out=1;
#else
  __DEBUG1("Waiting for connection!\n");
  // do everything by hand
  if ((listenfd=socket(AF_INET,SOCK_STREAM,0))<0) {
    syslog(LOG_WARNING,"Can't open stream socket");
    closelog();
    exit(EXIT_FAILURE);
  }

 // determine port to use
  sp=getservbyname(PVMKRIGE_PORT_NAME,"tcp");

  if (sp==NULL) {
    syslog(LOG_WARNING,"Unable to determine port number!\n");
    closelog();
    exit(EXIT_FAILURE);  
  }
  
  
  bzero((char*)&servaddr, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  servaddr.sin_port=htons(sp->s_port);
  
  if ((bind(listenfd, (struct sockaddr *) &servaddr,sizeof(servaddr))) < 0) {
    syslog(LOG_WARNING,"<bind> failed!");
    closelog();
    exit(EXIT_FAILURE);
  }
  
  if ((listen(listenfd,1))<0) {
    syslog(LOG_WARNING,"<listen> failed!");
    closelog();
    exit(EXIT_FAILURE);
  }
  
  len=sizeof(cliaddr);
  if ((fd_in=accept(listenfd,(struct sockaddr *)&cliaddr,&len)) < 0) {
    syslog(LOG_WARNING,"<accept> failed");
    closelog();
    exit(EXIT_FAILURE);
  }
 /*
  addrlen=sizeof(his_addr);
  if (getpeername(0,(struct sockaddr *)&his_addr,&addrlen) < 0) {
    syslog(LOG_WARNING,"<getpeername> failed");
    closelog();
    exit(EXIT_FAILURE);
  }
  
  // do we need to set some options?
  // setsockopt
  // fcntl
  // ioctl
  
  if (gethostname(hostname,sizeof(hostname))!=0) {
    syslog(LOG_WARNING,"<gethostname> failed");
    closelog();
    exit(EXIT_FAILURE);
  }
  
  __DEBUG2("Connection to host <%s> established!\n",hostname);
  */
  fd_out=fd_in;  
#endif // START_WITH_INETD

// determine start time
#ifdef LOG_STATISTIC
#ifdef USE_RDTSC 
  start=rdtsc();
#else
  start=time(NULL);
#endif
#endif
  __DEBUG1("Got connection to R!\n");

  // start communication with R 
  // sort of handshake            
  retval=readn(fd_in,(char*)&okmsg,sizeof(syncmsg));
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Read ok msg failed");	
    closelog();
    exit(EXIT_FAILURE);
  }
  retval=writen(fd_out,(char*)&okmsg,sizeof(syncmsg));
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Write ok msg failed!");	
    closelog();
    exit(EXIT_FAILURE);
  }
 
  // ------------------------------------------------------------
 
  // get information about parameter settings
  __DEBUG1("Reading parameter settings\n");
 
  retval=readn(fd_in,(char*)&parameter,sizeof(message));  
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Failed to read parameters");	
    closelog();
    exit(EXIT_FAILURE);
  }
  __DEBUG7("Plen %d, Slen: %d, Para0: %f, Para1: %f, Para2: %f, Model: %d\n",
	   parameter.int_message.plen,parameter.int_message.slen,parameter.double_message.param0,
	   parameter.double_message.param1,parameter.double_message.param2,parameter.int_message.model);


  retval=writen(fd_out,(char*)&okmsg,sizeof(syncmsg));
  if (retval==FAILURE) {
	syslog(LOG_WARNING,"Failed to write syncmsg msg");	
	closelog();
  	exit(EXIT_FAILURE);
  }
  __DEBUG1("Ready to receive data\n");

  //  retval=large_get(sockfd,(double**) &A);
  // allocate memory 
  pointx=(double*)malloc(parameter.int_message.plen*sizeof(double));
  TEST_NULL(pointx,"Memory allocation problem (pointx)");

  pointy=(double*)malloc(parameter.int_message.plen*sizeof(double));
  TEST_NULL(pointx,"Memory allocation problem (pointy)");
 
  pointz=(double*)malloc(parameter.int_message.plen*sizeof(double));
  TEST_NULL(pointz,"Memory allocation problem (pointz)");

  sx=(double*)malloc(parameter.int_message.slen*sizeof(double));
  TEST_NULL(sx,"Memory allocation problem (sx)");
 
  sy=(double*)malloc(parameter.int_message.slen*sizeof(double));
  TEST_NULL(sy,"Memory allocation problem (sy)");
 
  zhat=(double*)malloc(parameter.int_message.slen*sizeof(double));
  TEST_NULL(zhat,"Memory allocation problem (zhat)");
 
  sigma2hat=(double*)malloc(parameter.int_message.slen*sizeof(double));
  TEST_NULL(sigma2hat,"Memory allocation problem (sigma2hat)");
  
  gmatrix_inv=(double*)malloc((parameter.int_message.plen+1)*(parameter.int_message.plen+1)*sizeof(double));
  TEST_NULL(gmatrix_inv,"Memory allocation problem (gmatrix_inv)");

  gvector=(double*)malloc((parameter.int_message.plen+1)*sizeof(double));
  TEST_NULL(gvector,"Memory allocation problem (gvector)");

  dst=(double*)malloc(parameter.int_message.plen*sizeof(double));
  TEST_NULL(dst,"Memory allocation problem (dst)");
 
  lambda_hat=(double*)malloc((parameter.int_message.plen+1)*sizeof(double));
  TEST_NULL(lambda_hat,"Memory allocation problem (lambda_hat)");

  sdo=(double*)malloc(parameter.int_message.slen*sizeof(double));
  TEST_NULL(sdo,"Memory allocation problem (sdo)");
 
  // receive data
  recv_data(fd_in,pointx,parameter.int_message.plen*sizeof(double),"pointx","Could not receive data correctly",
	    "No response from R-client after he sent pointx!");
  recv_data(fd_in,pointy,parameter.int_message.plen*sizeof(double),"pointy","Could not receive data correctly",
	    "No response from R-client after he sent pointy!");
  recv_data(fd_in,pointz,parameter.int_message.plen*sizeof(double),"pointz","Could not receive data correctly",
	    "No response from R-client after he sent pointz!");
  recv_data(fd_in,sx,parameter.int_message.slen*sizeof(double),"sx","Could not receive data correctly",
	    "No response from R-client after he sent sx!");
  recv_data(fd_in,sy,parameter.int_message.slen*sizeof(double),"sy","Could not receive data correctly",
	    "No response from R-client after he sent sy!");
  recv_data(fd_in,zhat,parameter.int_message.slen*sizeof(double),"zhat","Could not receive data correctly",
	    "No response from R-client after he sent zhat!");
  recv_data(fd_in,sigma2hat,parameter.int_message.slen*sizeof(double),"sigma2hat","Could not receive data correctly",
	    "No response from R-client after he sent sigma2hat!");
  recv_data(fd_in,gmatrix_inv,(parameter.int_message.plen+1)*(parameter.int_message.plen+1)*sizeof(double),"gmatrix_inv","Could not receive data correctly",
	    "No response from R-client after he sent gmatrix_inv");
  recv_data(fd_in,gvector,(parameter.int_message.plen+1)*sizeof(double),"gvector","Could not receive data correctly",
	    "No response from R-client after he sent gvector");
  recv_data(fd_in,dst,parameter.int_message.plen*sizeof(double),"dst","Could not receive data correctly",
	    "No response from R-client after he sent dst");
  recv_data(fd_in,lambda_hat,(parameter.int_message.plen+1)*sizeof(double),"lambda_hat","Could not receive data correctly",
	    "No response from R-client after he sent lambda_hat!");
  recv_data(fd_in,sdo,parameter.int_message.slen*sizeof(double),"sdo","Could not receive data correctly",
	    "No response from R-client after he sent sdo!");

   /*
     storage allocation
         zeile data
       -------------
       |           |
     Z1S1  Z2S1  Z1S2  Z2S2
       |           |
        ------------
     dim_zeile 
   */

  __DEBUG1("Going to start pvm...\n");


  // pvm_krige found in pvmstuff.c
  pvm_krige(pointx,pointy,pointz,parameter.int_message.plen,sx,sy,parameter.int_message.slen,
	    zhat,sigma2hat,parameter.int_message.model,parameter.double_message.param0,parameter.double_message.param1,parameter.double_message.param2,gmatrix_inv, 
	    gvector,dst,lambda_hat,sdo);


  // ------------------------------------------------------------

  __DEBUG1("pvm_krige finished!\n");

    // notify R that data is ready
  retval=writen(fd_out,(char*)&zhat[0],parameter.int_message.slen*sizeof(double));
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Failed to write zhat!");	
    closelog();
    exit(EXIT_FAILURE);
  }                  

  // read syncmsg
  retval=readn(fd_in,(char*)&okmsg,sizeof(syncmsg));  
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Failed to read syncmsg!");	
    closelog();
    exit(EXIT_FAILURE);
  }

  // send sigma2hat
  retval=writen(fd_out,(char*)&sigma2hat[0],parameter.int_message.slen*sizeof(double));
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Failed to write sigma2hat!");	
    closelog();
    exit(EXIT_FAILURE);
  }                  

  // read syncmsg
  retval=readn(fd_in,(char*)&okmsg,sizeof(syncmsg));  
  if (retval==FAILURE) {
    syslog(LOG_WARNING,"Faild to read final syncmsg!");	
    closelog();
    exit(EXIT_FAILURE);
  }

// determine finish time
#ifdef LOG_STATISTIC
#ifdef USE_RDTSC
  end=rdtsc();
#else
  end=time(NULL);
#endif
#ifdef START_WITH_INETD
#ifdef USE_RDTSC
 __DEBUG2("Total runtime (msec): %10.3f\n",tsc_to_ms(end-start));
#else
 __DEBUG2("Total runtime (sec): %10.3f\n",(float)(difftime(start,end)));
#endif
#else
#ifdef USE_RDTSC
 printf("Total runtime (ms): %10.3f\n",tsc_to_ms(end-start));
#else 
 printf("Total runtime (sec): %10.3f\n",(float)(difftime(start,end)));
#endif
#endif
#endif

  __DEBUG1("sigma2hat written successfully..done\n");
 
  closelog();
  exit(EXIT_SUCCESS);
}                                       
