
#ifndef PVMSTUFF
#define PVMSTUFF  1
#include <pvm3.h>
#include <time.h>
#include "inet.h"

// could be evaluated during runtime
#define POINTS_TO_SEND 100

#define CLIENT_TO_START "krige_client"

// this variable is used to write a job 
// statistic to a file

#define LOG_STATISTIC 1

#define MAX_NR_WORKER 20

//#define USE_MULTICAST 1

// only initial send is used for multicast!
#define MSGTAG_INITIALSEND 1
// regular job 
#define MSGTAG_SENDJOB 2
// messages used for notify
#define MSGTAG_TASKDIED 100
#define MSGTAG_HOSTDELETE 101
#define MSGTAG_HOSTADD 102
// default result message
#define MSGTAG_KRIGE 999

// ways how hosts are added to the pvm daemon
#define FILE_ADDS_HOSTS 1 
#define PVM_ADDS_HOSTS 2

#define PVM_HOSTFILE "~/.pvmhostfile"

int add_tile_hosts2pvm(int how);



// nr of points is sent first (in order to allocate the appropriate size of memory required)

typedef struct job {  
  double sx[POINTS_TO_SEND];
  double sy[POINTS_TO_SEND];
  double nr_points;
  double id;
} job;

typedef struct tile_job {  
    int i_lower;
    int i_upper;
    int j_lower;
    int j_upper;
    int nr_points;
    int id;
} tile_job;


typedef struct host_t {
  char *hostname;
  int speed;
  struct host_t *next; 
  int tid; // pvm identity
  // number of total point processed
  double nr_points; 
#ifdef USE_RDTSC
  unsigned long long int total_time;
  unsigned long long int start;
#else 
  time_t total_time;  
  time_t start;
#endif
  double pending;
  job *last_job;
  int status;
} host_t;


// define job queue for jobs pending because of crashed clients

typedef struct jqueue_t {
  struct jqueue_t *next;
  struct job *jobptr; 
} jqueue_t;

typedef struct job_queue_t {
  jqueue_t *first;
  int nr;
} job_queue_t;

typedef struct tjqueue_t {
    struct tjqueue_t *next;
    int todo;
    struct tile_job *jobptr; 
    struct tile_result *resultptr;  
} tjqueue_t;

typedef struct tile_job_queue_t {
    tjqueue_t *first;
    int nr;
    int nr_done;
    int nr_todo;
    int id_counter;
    int jobs_pending;
} tile_job_queue_t;


int tile_queue_addjob(tile_job_queue_t *tile_job_queue,tile_job* jobptr);
int tile_queue_removejob(tile_job_queue_t *tile_job_queue,tile_job** jobptr);

int queue_addjob(job_queue_t *job_queue,job* jobptr);
int queue_removejob(job_queue_t *job_queue,job** jobptr);

#define WRITE_MODE "a"


typedef struct result {
  double nr_points;
  double id;
  double zhat[POINTS_TO_SEND];
  double sigma2hat[POINTS_TO_SEND];
} result;

typedef struct tile_result {
  double nr_points;
  double id;
  double *z;
  double *var;
} tile_result;

typedef struct tile_host_t {
  char *hostname;
  int speed;
  struct tile_host_t *next; 
  int tid; // pvm identity
  // number of total point processed
  double nr_points; 
#ifdef USE_RDTSC
  unsigned long long int total_time;
  unsigned long long int start;
#else 
  time_t total_time;  
  time_t start;
#endif
  double pending;
  tjqueue_t *last_queueentry;
  int status;
} tile_host_t;

// define values for status of a host
#define HOST_STATUS_READY 0 
#define HOST_STATUS_HOSTDELETE 1
#define HOST_STATUS_TASKDIED 2 

typedef struct hostlist_t {
  int nr; // stored to provide faster access
  host_t *first_host;
} hostlist_t;

hostlist_t hostlist;

typedef struct tile_hostlist_t {
  int nr; // stored to provide faster access
  tile_host_t *first_host;
} tile_hostlist_t;

tile_hostlist_t tile_hostlist;
//host_t host;


  
void pvm_krige(double *pointx,double *pointy, double *pointz, long plen, double *sx, double *sy, long slen,
		 double *zhat, double *sigma2hat, int model, double param0,double param1, double param2, double *gmatrix_inv, 
		 double *gvector, double *dst, double *lambda_hat, double *sdo);

#if 0
void pvm_krige_tiles(double *lon,
		     double *lat,
		     double *z,
		     double *xgwork,
		     double *ygwork,
		     int *dog,
		     static_msg param,
		     size_msg param_size,
		     double *zg,
		     double *varg
		     int *gridcnt);
#endif


#endif

