#include "inet.h"

int readn(register int fd,register char *ptr,register int nbytes)
{
 int nleft,nread;
 nleft=nbytes;
 while (nleft >0)
 {
  nread=read(fd,ptr,nleft);
  if (nread<0) return(nread);
  else if (nread ==0) break;
  nleft-=nread;
  ptr+=nread;
 }
 return(nbytes-nleft);
}

int writen(register int fd,register char *ptr,register int nbytes)
{
 int nleft,nwritten;
 
 nleft=nbytes;
 while (nleft>0) 
 {
    nwritten=write(fd,ptr,nleft);
    if (nwritten<=0) return(nwritten);
    nleft-=nwritten;
    ptr+=nwritten;
 }
 return (nbytes -nleft);
}

int read_socket(register int fd,register char* ptr,register int bytes)
{
  int retval;
  do
    retval = recv(fd, ptr, bytes, 0);
  while (retval == -1 && errno == EINTR);
  if (retval==-1) return(FAILURE);
  else return(bytes);
}

int write_socket(register int fd,register char *ptr,register int bytes)
{
  int retval;
  do
    retval = send(fd, ptr, bytes, 0);
  while (retval == -1 && errno == EINTR);
  if (retval==-1) return(FAILURE);
  else return(bytes);
}

