#ifdef PVM_DEBUG

#include "../pvm_debug.h"
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h> 
#include <string.h>

int testdebugfile(char *file) {
  FILE *fp;
  int res=-1;
  fp=fopen(file,"r");
  if (fp!=NULL){
    fclose(fp);
    res=0;
  }
  return res;
}


int erasedebugfile(char *file) {
  FILE *fp;
  int res=-1;
  fp=fopen(file,"w");
  if (fp!=NULL) {
    fprintf(fp,"");
    res=0;
    fclose(fp);
  }
  return res;
}

int setdebugfile(char *file) {
  int i;
  if (file==NULL) return -1;
  else {
    if (strlen(file)>=MAX_FILE_LEN) return -2;
    else {
      // clear everything first
      for (i=0; i<MAX_FILE_LEN; i++) filename[i]='\0';
      memcpy(filename,file,strlen(file));
      return strlen(file);
    }
  }
}


int debug(const char *fmt, ...) {
  FILE *fp;
  va_list az;
  int res=-1;
  char buffer[MAX_BUFFER];
  va_start(az,fmt);
  vsprintf(buffer,fmt,az);
  
  fp=fopen((char*)filename,"a");
  if (fp!=NULL) {
    fprintf(fp,"%s\n",buffer);
    fclose(fp);
    res=0;
  }
  va_end(az);
  return res;
}
#endif
