\name{plot.voronoi}
\title{Plot a voronoi object}
\author{A. Gebhardt}
\usage{plot(voronoi.obj, add=FALSE, ...)
}
\alias{plot.voronoi}
\arguments{
  \item{voronoi.obj}{object of class \code{"voronoi"}}
  \item{add}{logical. if \code{TRUE}, add to a current plot.}
  \item{...}{additional plot parameters}
}
\description{Plots the mosaic \code{"voronoi.obj"}.

  Dashed lines are used for outer tiles of the mosaic.
}
\value{None
}
\references{
   R. J. Renka (1996). Algorithm 751: TRIPACK: a constrained
  two-dimensional {Delaunay} triangulation package.
  ACM Transactions on Mathematical Software.
  \bold{22}, 1-8. 
}
\seealso{
  \code{\link{voronoi}}, \code{\link{print.voronoi}}, 
  \code{\link{summary.voronoi}}
}
\examples{
plot(voronoi.mosaic(runif(100),runif(100),duplicate="remove"))
}
\keyword{}
