      SUBROUTINE INHULL(XP,YP,NP,X,Y,N,LIST,LPTR,LEND,INH)
      INTEGER N, LIST(*), LPTR(*), LEND(N)
      DOUBLE PRECISION    XP(*), YP(*), X(*), Y(*)
      LOGICAL INH(*)
C
C***********************************************************
C
C                                               From TRIPACK
C                                            Robert J. Renka
C                                  Dept. of Computer Science
C                                       Univ. of North Texas
C                                             (817) 565-2767
C                                                   09/01/88
C
C   Modified version of BNODES from TRIPACK
C   Albrecht Gebhardt <albrecht.gebhardt@uni-klu.ac.at>
C   
C This function returns TRUE if a given point is contained
C in the convex hull of a given triangulation.
C
C On input:
C
C       PX,PY = coordinates of the point to be located
C
C       X,Y = Arrays containing the coordinates of the nodes
C             in the triangulation.
C
C       N = Number of nodes in the triangulation.  N .GE. 3.
C
C       LIST,LPTR,LEND = Data structure defining the trian-
C                        gulation.  Refer to subroutine
C                        TRMESH.
C
C The above parameters are not altered by this routine.
C
C Return value:
C
C       TRUE if (PX,PY) lies in convex hull of the triangulation.
C
C       This is determined by sequentially applying the LEFT
C       function along the boundary (counterclockwise). 
C       If all these tests return TRUE (PX,PY) lies in the convex hull.
C
C Modules required by INHULL:  LEFT
C
C***********************************************************
C     
      INTEGER K, LP, N0, NST
      INTEGER NODES(N),IP
      LOGICAL LEFT

      DO 10, IP=1,NP
C 
C     initialize LOGICAL INH 
C
      INH(IP) = .TRUE.
C     
C     Set NST to the first boundary node encountered.
C     
      NST = 1
 1    LP = LEND(NST)
      IF (LIST(LP) .LT. 0) GO TO 2
      NST = NST + 1
      GO TO 1
C     
C     Initialization.
C     
 2    NODES(1) = NST
      K = 1
      N0 = NST
C     
C     Traverse the boundary in counterclockwise order.
C     
 3    LP = LEND(N0)
      LP = LPTR(LP)
      N0 = LIST(LP)
      IF (N0 .EQ. NST) GO TO 4
      K = K + 1
      NODES(K) = N0
C     
C     Check if point (X,Y) is left of the line through NODES(K-1)->NODES(K),
C     
      INH(IP) = INH(IP) .AND. LEFT(X(NODES(K-1)),Y(NODES(K-1)),
     .                             X( NODES(K)),Y(NODES(K)),
     .                             XP(IP),YP(IP))
      GO TO 3        
C     
C     Check if point (X,Y) is left of the line through NODES(NB)->NODES(1),
C     
 4    INH(IP) = INH(IP) .AND. LEFT(X(NODES(K)),Y(NODES(K)),
     .                             X(NODES(1)),Y(NODES(1)),
     .                             XP(IP),YP(IP))

 10   CONTINUE
      RETURN
      END
