\name{in.convex.hull}
\title{Determines if points are in the convex hull of a triangulation object}
\author{A. Gebhardt}
\usage{in.convex.hull(tri.obj, x, y)
}
\alias{in.convex.hull}
\arguments{
  \item{tri.obj}{object of class \code{"tri"}}
  \item{x}{vector of x-coordinates of points to locate}
  \item{y}{vector of y-coordinates of points to locate}
}
\description{
Given a triangulation \code{tri.obj} of \eqn{n} points in the plane, this
subroutine returns a logical vector indicating if the points
\eqn{(x_i,y_i)}
are contained within the convex hull of \code{tri.obj}.

}
\value{
Logical vector.
}
\references{
  R. J. Renka (1996). Algorithm 751: TRIPACK: a constrained
  two-dimensional {Delaunay} triangulation package.
  ACM Transactions on Mathematical Software.
  \bold{22}, 1-8.
}
\seealso{
  \code{\link{tri}}, \code{\link{print.tri}}, \code{\link{plot.tri}},
  \code{\link{summary.tri}}, \code{\link{triangles}},
  \code{\link{add.constraint}}, \code{\link{convex.hull}}.
}
\examples{
tr<-tri.mesh(tritest$x,tritest$y)
in.convex.hull(tr,0.5,0.5)
in.convex.hull(tr,c(0.5,-1,1),c(0.5,1,1))
}
\keyword{}
