"ppinit"<- function(file)
{
  file.exists <- function(name) {
    if(machine() == "Unix") system(paste("test -r", name), intern = F) == 0
  }
  tfile <- file
  t1file <- paste(.Library,"spatial/data",file,sep="/")
  if(file.exists(t1file)) tfile <- t1file
  h <- scan(tfile, list(xl = 0, xu = 0, yl = 0, yu = 0, fac = 0),
	    nmax = 5, skip = 2)
  pp <- scan(tfile, list(x = 0, y = 0), skip = 3)
  pp$x <- pp$x/h$fac
  pp$y <- pp$y/h$fac
  pp$xl <- h$xl/h$fac
  pp$xu <- h$xu/h$fac
  pp$yl <- h$yl/h$fac
  pp$yu <- h$yu/h$fac
  if(!is.loaded(symbol.C("VR_ppset"))) 
    stop("Compiled code has not been dynamically loaded")
  ppregion(pp)
  invisible(pp)
}

"Kfn"<- function(pp, fs, k = 100)
{
  z <- .C("VR_sp_pp2",
	  as.double(pp$x),
	  as.double(pp$y),
	  as.integer(length(pp$x)),
	  k1 = as.integer(k),
	  h = double(k),
	  dmin = double(1),
	  lm = double(1),
	  as.double(fs))
  list(y = z$h[1:z$k1], x = (seq(1:z$k1) * fs)/k, k = k, 
       dmin = z$dmin, lm = max(z$dmin, z$lm),
       call=match.call())
}

"Kenvl"<- function(fs, nsim, ...)
{
  dot.expression <- as.expression(substitute(...))
  h <- Kfn(pp = eval(dot.expression), fs)
  hx <- h$x
  hu <- h$y
  hl <- h$y
  ha <- h$y^2
  for(i in 2:nsim) {
    h <- Kfn(pp = eval(dot.expression), fs)$y
    hu <- pmax(hu, h)
    hl <- pmin(hl, h)
    ha <- ha + h^2
  }
  list(x = hx, lower = hl, upper = hu, aver = sqrt(ha/nsim),
       call=match.call())
}

"Kaver"<- function(fs, nsim, ...)
{
  dot.expression <- as.expression(substitute(...))
  h <- Kfn(pp = eval(dot.expression), fs)
  hx <- h$x
  ha <- h$y^2
  for(i in 2:nsim) {
    h <- Kfn(pp = eval(dot.expression), fs)$y
    ha <- ha + h^2
  }
  list(x = hx, y = sqrt(ha/nsim), call=match.call())
}

"ppregion"<- function(xl = 0, xu = 1, yl = 0, yu = 1)
{
  if(is.list(xl))  .C("VR_ppset", as.double(xl$xl), as.double(xl$xu), 
		      as.double(xl$yl), as.double(xl$yu))
  else  .C("VR_ppset", as.double(xl), as.double(xu),
	   as.double(yl), as.double(yu))
  invisible()
}

"Psim"<- function(n)
{
  z <- .C("VR_pdata",
	  as.integer(n),
	  x = double(n),
	  y = double(n))
  invisible(list(x = z$x, y = z$y, call=match.call()))
}

"Strauss"<- function(n, c = 0, r)
{
  init <-  0
  if(!exists("ppx")) {
    init <-  1
    z <- .C("VR_pdata",
	    as.integer(n),
	    x = double(n),
	    y = double(n))
    assign("ppx", z$x)
    assign("ppy", z$y)
  }
  z <- .C("VR_simpat",
	  as.integer(n),
	  x = ppx,
	  y = ppy,
	  as.double(c),
	  as.double(r),
	  as.integer(init))
  assign("ppx", z$x)
  assign("ppy", z$y)
  invisible(list(x = z$x, y = z$y, call=match.call()))
}

"SSI"<- function(n, r)
{
  z <- .C("VR_simmat",
	  as.integer(n),
	  x = double(n),
	  y = double(n),
	  as.double(r))
  invisible(list(x = z$x, y = z$y, call=match.call()))
}

"pplikfn"<- function(cc, R, n, x, y, ng, target, trace=F)
{
  z <- .C("VR_plike",
	  as.double(x),
	  as.double(y),
	  as.integer(n),
	  as.double(cc),
	  as.double(R),
	  as.integer(ng),
	  as.double(target),
	  res=double(1)
	  )
  if(trace) print(c(cc, z$res))
  z$res
}

"pplik"<- function(pp, R, ng=50, trace=F)
{
  n <- length(pp$x)
  target <- n * (Kfn(pp, R,1)$y)^2 * pi /
    ((pp$xu - pp$xl) * (pp$yu - pp$yl))
  if(target == 0) return(0)
  tmp <- pplikfn(1, R, n, pp$x, pp$y, ng, target, F)
  if(tmp <= 0) return(1)
  uniroot(pplikfn, c(0,1), lower=-target, upper=tmp,
	  R=R, n=n, x=pp$x, y=pp$y, ng=ng, target=target,
	  trace=trace)$root
}

