krige.tiles <- function(point.obj,
                        at,
                        var.mod.obj,
                        xsw=NULL,ysw=NULL,xne=NULL,yne=NULL,
                        dx=NULL,dy=NULL,itx=NULL,ity=NULL,
                        angle=NULL,
                        maxdist = NULL,
                        extrap = FALSE,
                        trend=0,
                        rsearch=0,
                        nsearch=0,
                        nsmin=-1,
                        nsmax=-1,
                        mode=3)
  {
    if(is.null(angle))angle<-0

    if(is.null(xsw)) xsw<-min(point.obj$x)
    if(is.null(xne)) xne<-max(point.obj$x)
    if(is.null(ysw)) ysw<-min(point.obj$y)
    if(is.null(yne)) yne<-max(point.obj$y)

    dgx<-xne-xsw
    dgy<-yne-ysw

    if(is.null(dx)) dx <- dgx/20
    if(is.null(dy)) dy <- dgy/20
    if(is.null(itx)) itx <- 4
    if(is.null(ity)) ity <- 4

    nx<-ceiling(dgx/dx)+1
    ny<-ceiling(dgy/dy)+1
    ntx<-ceiling(nx/itx)
    nty<-ceiling(ny/ity)

    at <- point.obj[[match(at, names(point.obj))]]
    n<-length(point.obj$x)
    nz<-nx*ny
    nt<-ntx*nty
    ipt<-itx*ity
    
    dog <- matrix(1, nx, ny)
    if (!extrap) {
      tmpgrd <- cbind(rep(seq(xsw,xne,length=nx),ny),sort(rep(seq(ysw,yne,length=ny),nx)))
      dog <- in.convex.hull(tri.mesh(point.obj$x,point.obj$y, 
                                     duplicate = "remove"), tmpgrd[,1], tmpgrd[,2])
      # workaround for int <-> unsigned int problem on alpha platform:
      dog <- abs(as.numeric(dog))
      dog <- matrix(dog, nx, ny,byrow=F)
    }
    
    extrap<-1*extrap

    if (!inherits(point.obj, "point")) 
      stop("point.obj must be of class, \"point\".\n")
    if (!inherits(var.mod.obj, "variogram.model")) 
      stop("var.mod.obj must be of class, \"variogram.model\".\n")
    if(mode==1 && length(at)!=n) stop("length of x and z differ\n")
    if(rsearch>0 & nsearch>0)
      stop("specify only one of rsearch and nsearch\n")
    if(nsmin>nsmax)
      stop("nsmin>nsmax\n")
#    if(rsearch>0){
#      if(nsmin==0) nsmin<-ceiling(n*0.1)
#      if(nsmax==0) nsmax<-ceiling(n*0.9)
#    }
    if(trend==0) ntrend<-1
    if(trend==1) ntrend<-3
    if(trend==2) ntrend<-6

    covtype<-switch(attr(var.mod.obj,"type"),
                    exponential=1,
                    gaussian=2,
                    spherical=3,
                    linear=4,
                    0)
    c0<-0
    covmat<-matrix(0,n,n)
     

#    print(c(nx,ny,nz))
    
    ans<-.Fortran("krgtil",
                  xsw=as.double(xsw),
                  ysw=as.double(ysw),                 
                  xne=as.double(xne),                 
                  yne=as.double(yne),                 
                  angle=as.double(angle),                 
                  nx=as.integer(nx),                 
                  ny=as.integer(ny),                 
                  nz=as.integer(nz),                 
                  ntx=as.integer(ntx),                 
                  nty=as.integer(nty),                 
                  nt=as.integer(nt),                 
                  dx=as.double(dx),                 
                  dy=as.double(dy),                 
                  itx=as.integer(itx),                 
                  ity=as.integer(ity),                 
                  ipt=as.integer(ipt),                 
                  xg=double(nx),                 
                  yg=double(ny),                 
                  zg=double(nz),
                  varg=double(nz),
                  dog=as.integer(dog),
                  xgwork=double(nz),
                  ygwork=double(nz),
                  lon=as.double(point.obj$x),
                  lat=as.double(point.obj$y),
                  z=as.double(at),
                  extrap=as.integer(extrap),
                  n=as.integer(n),
                  covtype=as.integer(covtype),
                  covpar=as.double(var.mod.obj$parameters),
                  covmat=as.double(covmat),
                  ldcov=as.integer(n),
                  c0vec=double(n*ipt),
                  ldc0vec=as.integer(n),
                  c0=as.double(c0),
                  extcov=as.integer(0),
                  trend=as.integer(trend),
                  ntrend=as.integer(ntrend),
                  rsearch=as.double(rsearch),
                  nsearch=as.integer(nsearch),
                  nsmin=as.integer(nsmin),
                  nsmax=as.integer(nsmax),
                  fwork=double(n*ntrend),
                  ldfwrk=as.integer(n),
                  f0work=double(ipt*ntrend),
                  dist=double(n),
                  indsnb=integer(n),
                  indsna=integer(n),
                  indsrt=integer(n),
                  kwork=double((n+ntrend)*(n+ntrend)),
                  nkwork=as.integer(n+ntrend),
                  rhswork=double(ipt*(n+ntrend)),
                  ipiv=integer(ipt*(n+ntrend)),
                  mode=as.integer(mode),
                  mu=double(ipt*ntrend),
                  lambda=double(n*ipt),
                  ldlmbd=as.integer(n),
                  x0=double(ipt),
                  y0=double(ipt),
                  z0=double(ipt),
                  do0=integer(ipt),
                  inddo=integer(ipt),
                  var0=double(ipt),
                  ierr=integer(1))
    
#    ans<-krige.solve(s$x,s$y,point.obj$x,point.obj$y,
#                     at,covmat,c0vec,c0,trend,rsearch,nsmin,nsmax,mode)

    retval<-list(x=ans$xg,
                 y=ans$yg,
                 z=matrix(ans$zg,nx,ny),
                 var=matrix(ans$varg,nx,ny),
                 done=matrix(dog, nx, ny, byrow = F))
    retval$z[retval$done<=0] <- NA
    retval$var[retval$done<=0] <- NA
    retval    
  }
