/* ../src/linbin.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* ccccccccc FORTRAN subroutine linbin.f cccccccccc */
/* Obtains bin counts for univariate data */
/* via the linear binning strategy. If "trun=0" then */
/* weight from end observations is given to corresponding */
/* end grid points. If "trun=1" then end observations */
/* are truncated. */
/* Last changed: 27/01/95 */
/* Subroutine */ int linbin_(x, n, a, b, m, trun, gcounts)
doublereal *x;
integer *n;
doublereal *a, *b;
integer *m, *trun;
doublereal *gcounts;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer i;
    static doublereal delta;
    static integer li;
    static doublereal rem, lxi;

/*     Initialize grid counts to zero */
    /* Parameter adjustments */
    --gcounts;
    --x;

    /* Function Body */
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	gcounts[i] = 0.;
/* L10: */
    }
    delta = (*b - *a) / (*m - 1);
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	lxi = (x[i] - *a) / delta + 1;
/*        Find integer part of "lxi" */
	li = (integer) lxi;
	rem = lxi - li;
	if (li >= 1 && li < *m) {
	    gcounts[li] += 1 - rem;
	    gcounts[li + 1] += rem;
	} else if (li < 1 && *trun == 0) {
	    ++gcounts[1];
	} else if (li >= *m) {
	    if (li == *m || *trun == 0) {
		++gcounts[*m];
	    }
	}
/* L20: */
    }
    return 0;
} /* linbin_ */

