\name{bkde}
\title{Compute a Binned Kernel Density Estimate}
\usage{bkde (x,kernel="normal",canonical=F,bandwidth,
             gridsize=401,range.x=range(x),truncate=T)
}
\alias{bkde}
\arguments{
Required:
\item{x}{vector of observations from the distribution whose density
       is to be estimated.  Missing values are not allowed.}
\item{bandwidth}{the  kernel  bandwidth  smoothing parameter.  Larger
       values of \code{bandwidth}  make  smoother  estimates,  smaller
       values of \code{bandwidth} make less smooth estimates.}
Optional:
\item{kernel}{character string which determines the smoothing kernel.
       \code{kernel} can be:

\code{"normal"} - the Gaussian density function (the  default).

\code{"box"} - a rectangular box.

\code{"epanech"} - the centred beta(2,2) density.

\code{"biweight"} - the centred beta(3,3) density.

\code{"triweight"} - the centred beta(4,4) density.}
\item{canonical}{logical flag: if TRUE, canonically scaled kernels are
       used.}
\item{gridsize}{the number of equally spaced points at which to  esti
       mate the density.}
\item{range.x}{vector  containing the minimum and maximum values of x
       at which to compute the estimate.  The default is the min
       imum and maximum data values.}
\item{truncate}{logical flag: if TRUE, data with x values outside the
       range specified by range.x are ignored.}
}
\value{ a list containing the following components:
\item{x}{vector of sorted x values at which the estimate  was  com
       puted.}
\item{y}{vector of density estimates at the corresponding \code{x}.}
}
\description{
Returns  x  and y coordinates of the binned kernel density
       estimate of the probability density of the data.
}
\note{
This  is  the  binned approximation to the ordinary kernel
       density estimate.  Linear binning is used  to  obtain  the
       bin  counts.  For each `x' value in the sample, the kernel
       is centered on that `x' and the heights of the kernel at
       each  datapoint  are summed.  This sum, after a normalization, 
is the corresponding `y' value in the  output.   
Results  are currently computed to single-precision accuracy only.

Density estimation is a smoothing  operation.   Inevitably
       there  is a trade-off between bias in the estimate and the
       estimate's  variability:  large  bandwidths  will  produce
       smooth  estimates that may hide local features of the den
       sity; small bandwidths may introduce spurious  bumps  into
       the estimate.
}
\seealso{\code{\link{density}}, \code{\link{hist}}, \code{\link{dpik}} 
}
\examples{
data(faithful)
x <- faithful$eruptions
est <- bkde(x,bandwidth=0.25)
plot(est,type="l")
}
\references{Wand,  M.  P.  and Jones, M. C. (1995).  Kernel Smoothing.
       Chapman and Hall, London.
}
