"cpblock" <-
function (X, Y, Nmax, q) 
{
        n <- length(X)
        # Sort the (X,Y) data with respect to
        # the X's.
        datmat <- cbind(X, Y)
        datmat <- datmat[sort.list(datmat[, 1]), ]
        X <- datmat[, 1]
        Y <- datmat[, 2]
        # Set up arrays for FORTRAN subroutine "cp"
        qq <- q + 1
        RSS <- rep(0, Nmax)
        Xj <- rep(0, n)
        Yj <- rep(0, n)
        coef <- rep(0, qq)
        Xmat <- matrix(0, n, qq)
        Cpvals <- rep(0, Nmax)
        wk <- rep(0, n)
        qraux <- rep(0, qq)
        out <- .Fortran("cp", as.double(X), as.double(Y), as.integer(n), 
                as.integer(q), as.integer(qq), as.integer(Nmax), 
                as.double(RSS), as.double(Xj), as.double(Yj), 
                as.double(coef), as.double(Xmat), as.double(wk), 
                as.double(qraux), as.double(Cpvals))
        Cpvec <- out[[14]]
        Nval <- order(Cpvec)[1]
        return(Nval)
}
