"bkfe" <-
function (x, drv, bandwidth, gridsize = 401, range.x, binned = F, 
        truncate = T) 
# Last changed: 18/12/95
{
        # Rename variables
        if (missing(range.x) & (binned == F)) 
                range.x <- c(min(x), max(x))
        M <- gridsize
        a <- range.x[1]
        b <- range.x[2]
        h <- bandwidth
        # Bin the data if not already binned
        if (binned == F) {
                gpoints <- seq(a, b, length = gridsize)
                gcounts <- linbin(x, gpoints, truncate)
        }
        else {
                gcounts <- x
                M <- length(gcounts)
                gpoints <- seq(a, b, length = M)
        }
        # Set the sample size and bin width 
        n <- sum(gcounts)
        delta <- (b - a)/(M - 1)
        # Obtain kernel weights
        tau <- 4 + drv
        L <- min(floor(tau * h/delta), M)
        lvec <- (0:L)
        arg <- lvec * delta/h
        kappam <- dnorm(arg)/(h^(drv + 1))
        hmold0 <- 1
        hmold1 <- arg
        hmnew <- 1
        if (drv >= 2) 
                for (i in (2:drv)) {
                        hmnew <- arg * hmold1 - (i - 1) * hmold0
                        # Compute mth degree Hermite polynomial
                        hmold0 <- hmold1
                        # by recurrence.
                        hmold1 <- hmnew
                }
        kappam <- hmnew * kappam
        # Now combine weights and counts to obtain estimate
        P <- 2^(ceiling(log(M + L)/log(2)))
        kappam <- c(kappam, rep(0, P - 2 * L - 1), kappam[(L + 
                1):2])
        Gcounts <- c(gcounts, rep(0, P - M))
        kappam <- fft(kappam)
        Gcounts <- fft(Gcounts)
        est <- sum(gcounts * (Re(fft(kappam * Gcounts, T))/P)[1:M])/(n^2)
        return(est)
}
