"bkde2D" <-
function (x, bandwidth, gridsize = c(51, 51), range.x, truncate = T) 
# Last changed: 25/08/95
{
        # Rename common variables
        n <- nrow(x)
        M <- gridsize
        h <- bandwidth
        # For bivariate normal kernel.
        tau <- 3.4
        # Use same bandwidth in each
        # direction if only a single
        # bandwidth is given.
        # If range.x is not specified then
        # set it at its default value.
        if (length(h) == 1) 
                h <- c(h, h)
        if (missing(range.x)) {
                range.x <- list(0, 0)
                for (id in (1:2)) {
                        range.x[[id]] <- c(min(x[, id]) - 1.5 * 
                                h[id], max(x[, id]) + 1.5 * h[id])
                }
        }
        a <- c(range.x[[1]][1], range.x[[2]][1])
        b <- c(range.x[[1]][2], range.x[[2]][2])
        # Set up grid points and bin the data
        gpoints1 <- seq(a[1], b[1], length = M[1])
        gpoints2 <- seq(a[2], b[2], length = M[2])
        gcounts <- linbin2D(x, gpoints1, gpoints2)
        # Compute kernel weights 
        L <- numeric()
        kapid <- list(0, 0)
        for (id in (1:2)) {
                L[id] <- min(floor(tau * h[id] * (M[id] - 1)/(b[id] - 
                        a[id])), (M[id] - 1))
                lvecid <- (0:L[id])
                facid <- (b[id] - a[id])/(h[id] * (M[id] - 1))
                kapid[[id]] <- matrix(dnorm(lvecid * facid)/h[id])
        }
        kapp <- kapid[[1]] %*% (t(kapid[[2]]))/n
        # Now combine weight and counts using the FFT
        # to obtain estimate
        # smallest powers of 2 >= M+L
        P <- 2^(ceiling(log(M + L)/log(2)))
        L1 <- L[1]
        L2 <- L[2]
        M1 <- M[1]
        M2 <- M[2]
        P1 <- P[1]
        P2 <- P[2]
        rp <- matrix(0, P1, P2)
        rp[1:(L1 + 1), 1:(L2 + 1)] <- kapp
        if (L1 > 0) 
                rp[(P1 - L1 + 1):P1, 1:(L2 + 1)] <- kapp[(L1 + 
                        1):2, 1:(L2 + 1)]
        # wrap-around version of "kapp" 
        if (L2 > 0) 
                rp[, (P2 - L2 + 1):P2] <- rp[, (L2 + 1):2]
        sp <- matrix(0, P1, P2)
        sp[1:M1, 1:M2] <- gcounts
        # zero-padded version of "gcounts" 
        # Obtain FFT's of r and s
        rp <- fft(rp)
        sp <- fft(sp)
        rp <- Re(fft(rp * sp, inverse = T)/(P1 * P2))[1:M1, 1:M2]
        # invert element-wise product of FFT's
        # and truncate and normalise it
        # Ensure that rp is non-negative
        rp <- rp * matrix(as.numeric(rp > 0), nrow(rp), ncol(rp))
        return(list(x1 = gpoints1, x2 = gpoints2, fhat = rp))
}
