"bkde" <-
function (x, kernel = "normal", canonical = F, bandwidth, gridsize = 401, 
        range.x, truncate = T) 
# Last changed: 16/06/95
{
        # Rename common variables
        n <- length(x)
        M <- gridsize
        # Set canonical scaling factors   
        if (kernel == "normal") 
                del0 <- (1/(4 * pi))^(1/10)
        if (kernel == "box") 
                del0 <- (9/2)^(1/5)
        if (kernel == "epanech") 
                del0 <- 15^(1/5)
        # Set default bandwidth
        if (kernel == "biweight") 
                del0 <- 35^(1/5)
        if (kernel == "triweight") 
                del0 <- (9450/143)^(1/5)
        if (missing(bandwidth)) {
                if (canonical) {
                        bandwidth <- (243/(35 * n))^(1/5) * sqrt(var(x))
                }
                else {
                        bandwidth <- del0 * (243/(35 * n))^(1/5) * 
                                sqrt(var(x))
                }
        }
        h <- bandwidth
        # Set kernel support values
        if (canonical) {
                if (kernel == "normal") {
                        tau <- 4 * del0
                }
                else {
                        tau <- del0
                }
        }
        else {
                if (kernel == "normal") {
                        tau <- 4
                }
                else {
                        tau <- 1
                }
        }
        if (missing(range.x)) {
                range.x <- c(min(x) - tau * h, max(x) + tau * 
                        h)
        }
        a <- range.x[1]
        b <- range.x[2]
        # Set up grid points and bin the data
        if (a == b) 
                stop("invalid x range (=0)\n")
        gpoints <- seq(a, b, length = M)
        gcounts <- linbin(x, gpoints, truncate)
        # Compute kernel weights 
        L <- min(floor(tau * h * (M - 1)/(b - a)), M)
        lvec <- (0:L)
        delta <- (b - a)/(h * (M - 1))
        # Now combine weight and counts to obtain estimate
        if (canonical == F) 
                del0 <- 1
        if (kernel == "normal") {
                kappa <- dnorm(lvec * delta/del0)/(n * h * del0)
        }
        else if (kernel == "box") {
                kappa <- 0.5 * dbeta(0.5 * (lvec * delta/del0 + 
                        1), 1, 1)/(n * h * del0)
        }
        else if (kernel == "epanech") {
                kappa <- 0.5 * dbeta(0.5 * (lvec * delta/del0 + 
                        1), 2, 2)/(n * h * del0)
        }
        else if (kernel == "biweight") {
                kappa <- 0.5 * dbeta(0.5 * (lvec * delta/del0 + 
                        1), 3, 3)/(n * h * del0)
        }
        else if (kernel == "triweight") {
                kappa <- 0.5 * dbeta(0.5 * (lvec * delta/del0 + 
                        1), 4, 4)/(n * h * del0)
        }
        P <- 2^(ceiling(log(M + L)/log(2)))
        kappa <- c(kappa, rep(0, P - 2 * L - 1), kappa[(L + 1):2])
        gcounts <- c(gcounts, rep(0, P - M))
        kappa <- fft(kappa)
        gcounts <- fft(gcounts)
        return(list(x = gpoints, y = (Re(fft(kappa * gcounts, 
                T))/P)[1:M]))
}
