/* C-PROGRAM FOR KERNEL DENSITY ESTIMATION			*/
/* INTERFACE :							*/
/* data = vector of observations				*/
/* n = number of observations					*/
/* grid = vector with gridpoints				*/
/* fh = vector with estimates					*/
/* kernel = number of kerneltype between 1 and 6		*/
/* 1 = Uniform, 2 = Triangle,					*/
/* 3 = Epanechnikov, 4 = Quartic,				*/
/* 5 = Triweight, 6 = Gaussian,					*/
/* 7 = Cosinus							*/
/* h = bandwidth of the kernel estimation			*/
/* points = number of gridpoints where the			*/
/* estimation should be calculated				*/
/* range = minimum and maximum of data				*/


#include<stdio.h>
#include<math.h>
#define PI 3.14159265

double kernl1 (u)
double u;
{
  return(0.5);
}

double kernl2 (u)
double u;
{
  double w;
  w = 1-fabs(u);
  return(w);
}

double kernl3 (u)
double u;
{
  double w;
  w = 0.75 *(1-u*u);
  return(w);
}

double kernl4 (u)
double u;
{
  double w1, w2;
  w2 = 1-u*u;
  w1 = 0.9375 *w2 * w2;
  return(w1);
}

double kernl5 (u)
double u;
{
  double w1, w2;
  w2=1-u*u;
  w1 = 1.09375 *w2*w2*w2;
  return(w1);
}

double kernl6 (u)
double u;
{
  double w;
  w = 0.3989*exp(-0.5 *u*u);
  return(w);
}

double kernl7 (u)
double u;
{
  double w;
  w = PI *0.25*cos(0.5* PI * u);
  return(w);
}



kde(data,n,grid,fh,kernel,h,points,range)
double *data,*grid,*fh,*h,*range;
long *n,*kernel,*points;
{
  double gridmin,step,nh;
  long i,j,k1,k2;
  double (*kernelproc)();
  nh=h[0]*(double)n[0];

  switch (kernel[0])
  {
    case 1 :  kernelproc = kernl1; break;
    case 2 :  kernelproc = kernl2; break;
    case 3 :  kernelproc = kernl3; break;
    case 4 :  kernelproc = kernl4; break;
    case 5 :  kernelproc = kernl5; break;
    case 6 :  kernelproc = kernl6; break;
    case 7 :  kernelproc = kernl7; break;
    default:  printf(" Error in the choice of kernel"); return;
  }

/* left boundary of grid					*/

  gridmin=range[0]-h[0];
  
/* interval between two following points on the grid		*/
  step=(2.0*h[0]+range[1]-range[0])/(double)(points[0]-1);

/* grid								*/
  for (j=0;j<points[0];j++)
  {
    grid[j]=gridmin+step*(double)j;
  }
  
/* now the kernel function is set around each gridpoint		*/

  if(kernel[0]==6)
  {
    for(i=0;i<n[0];i++)
    {
      for(j=0;j<points[0];j++)
      {
        fh[j]+=kernelproc((grid[j]-data[i])/h[0])/nh;
      }
    }
  }
  else
/* Except for the Gaussian kernel (kernel[0]=6)			*/
/* the kernel weights are only positive in a			*/
/* interval fixed by the indices k1 and k2.			*/
  {
    for (i=0;i<n[0];i++)
    {
      k1=ceil((data[i]-h[0]-gridmin)/step);
      k2=floor((data[i]+h[0]-gridmin)/step);
      for (j=k1;j<k2+1;j++)
      {
        fh[j]+=kernelproc((grid[j]-data[i])/h[0])/nh;
      } /* endj */
    }  /* endi */
  } /* endif */
  return(0);
} /* end */

