/* Algorithm for calculation of the Biased-Cross-Validation	*/
/* for WARPing density estimation 				*/
#include<stdio.h>
#include<math.h>

cvbwarping(x,fm,delta,rangem,cv,kwe,origin,bin,frequ,index,n,numbin,kernel)

/* x <==> data							*/
/* fm <==> vector == 0 will contain density estimates		*/
/* delta bandwidth						*/
/* rangem <==> range of smoothing parameter M			*/
/* cv <==> value of cross-validation corresponding to M		*/
/* kwe <==> weights depending on the different kernels		*/
/* origin <==> left border of first bin				*/
/* bin <==> vector == 0 protocol for non-empty bins		*/
/* frequ <==> absolute frequencies of non-empty bins		*/
/* index <==> index of non-empty bins 				*/
/* n <==> number of data 					*/
/* numbin <==> number of small bins 				*/
/* kernel <==> kernel=1 <==> Quartic, =2 <==> Triweight		*/

double*x,*fm,*delta,*cv,*kwe,*origin;
long*rangem,*n,*kernel,*bin,*frequ,*index,*numbin;
{
  register long M,i,j,k,indexi,z;
  double zeta,kappa,tau,divisor,cm,h,score;
  double m[9];
  long nl,iabs;
  nl=0;
  
/* Binning the data						*/
/* Computation of index[] and frequ[] for the non-empty		*/
/* bins.  Number of last non-empty bin is nl			*/
 
  for (i=0;i<n[0];i++)
  {
    indexi=floor((x[i]-origin[0])/delta[0]);
/* the actual obs. belongs to the bin with number indexi		*/
    if (bin[indexi]==0)
/* if the actual observation is the first in that bin		*/
    {
      nl++;
/* the number of non-empty bins increases by 1			*/
      frequ[nl] = 1;
/* the number of obs. in this bin is 1 (at this time)		*/
      index[nl]=indexi;
      bin[indexi]=nl;
/* protocol of the position of the new				*/
/* non-empty bin (in frequ[] and index[])			*/
    }
    else
/* if the actual observation is not the first in this bin 	*/
    {
      frequ[bin[indexi]]++;
/* increase the number of obs. in belonging non-empty bin 	*/
    }
  }
/* The vector frequ contains nonzero values in positions 	*/
/* 1,2,3,..,nl.  The other values are prespecified  	*/
/* as 0, since frequ is installed as a 0-vector.  In		*/
/* analogy index contains the indices of the non-empty bins.  	*/
  for(M=rangem[0];M<rangem[1]+1;M++)
  {
    m[1]=(double)M;
/* Computation of first 8 powers of M in double m[i]=M^i	*/
    for(i=2;i<9;i++)
      m[i] = pow(m[1], (double)i);
    h=(double)M*delta[0];
/* resetting the vector for the density estimates		*/
    for(z=0;z<numbin[0];z++)
      fm[z]=0.0;
/* resetting the score						*/
    score=0.0;
/* Calculation of the functionals of M and kernel K		*/

    switch ( *kernel )
    {
      case 1 :
      { /* Quartic */
        tau=(16*m[4] +32*m[2]-13)/(112*m[2]+28);
        divisor=(16*m[4]-1)*(4*m[2]+1);
        kappa=15*m[1]/7*(1-(32*m[4]-28*m[2]+1)/divisor);
        zeta=30/7*(336*m[3]-420*m[2]+85*m[1]+104)/divisor;
        break;
      }
      case 2 :
      { /* Triweight */
        tau=(32*m[6]+80*m[4] +62*m[2]-69)/(288*m[4]+72*m[2]+60);
        divisor=(4*m[2]-1)*pow(24*m[4]+6*m[2]+5,2.0);
        kappa=350*m[1]/143*(1-(4492.8*m[8]-979.2*m[6]+2124*m[4]
      		  -866.4*m[2]-2755.2)/(3*divisor));
        zeta=630*(128*m[7]-448*m[5]+560*m[4]-280*m[3]-280*m[2]
        		+320*m[1]+35)/divisor;
        break;
      }
      default: printf("error in the choice of kernel !");
      return;
    }
/* end of the switch-part					*/

/* Calculation of the kernel depending weights.			*/
/* The factor c(M) assures that sum(w.M(i/M),1-M,M-1)=M.	*/
/* Note, in formula of cm the division by [n * h] does not	*/
/* belong to the theoretical value of cm, but is a factor,	*/
/* which has to be multiplied one time, since fm=1/(nh)*..	*/

    switch ( *kernel )
    {
      case 1 :
/* Quartic - kernel K(u)= c(M) * (1- u*u)^2 * I(|u|<=1)		*/
/* c(M)=15*M^4/(16*M^4-1)					*/
      {
        cm=0.9375/((1.0-0.0625*pow((double)M,-4.0))
      					*(double)n[0]*h);
        for (i=0;i<M;i++)
          kwe[i]=cm*pow(1-pow((double)i/(double)M,2.0),2.0);
        break;
      }
      case 2 :
/* Triweight-kernel K(u)=c(M)*(1-u*U)^3*I(|u|<=1)		*/
/* c(M)=35*M^6/(32*M^6+14/3*M^2-5/3)				*/
      {
        cm=1.09375/((1.0+0.14583333*pow((double)M,-4.0)
        -0.052083333*pow((double)M,-6.0))*(double)n[0]*h);
        for (i=0;i<M;i++)
          kwe[i]=cm*pow(1-pow((double)i/(double)M,2.0),3.0);
        break;
      }
      default: printf("error in the choice of kernel !");
      return;
    }
/* end of the switch-part					*/
/* Like Kernel estimates, where a kernel function is set	*/
/* around the observations, we group the calculated weights	*/
/* around the non-empty bins.					*/

    for (k=1;k<nl+1;k++)
    {
      for (i=1-M;i<M;i++)
      {
        fm[i+index[k]]=fm[i+index[k]]+kwe[abs(i)]*(double)frequ[k];
      }
    }
/* Calculation of sum over second differences			*/
    for(z=1;z<numbin[0]-1;z++)
      score+=pow(fm[z+1]-2*fm[z]+fm[z-1],2.0);
    score+=pow(fm[numbin[0]-1]-fm[numbin[0]-2],2.0);
    score+=pow(2*fm[0]-fm[1],2.0);
    score+=pow(fm[0],2.0)+pow(fm[numbin[0]-1],2.0);
    score*=delta[0]*0.25;
    score-=zeta/(4*(double)n[0]*m[2]*delta[0]);
    score*=pow(tau,2.0)+1/180;  
    cv[M-rangem[0]]=score+kappa/(3*(double)n[0]*m[2]*delta[0]);
  }  /* end of loop over M */
    
}/* end */
   
      				        
