\name{histogram}
\title{Haerdle's histogram function}
\usage{histogram(data, h, x0, plot.type=T, ...)
}
\alias{histogram}
\arguments{
Required:
\item{data}{a vector of data}
\item{h}{bin width}
\item{x0}{start of first bin}
Optional:
\item{plot.type}{If TRUE, plot the histogram}
\item{...}{further options to barplot}
}
\value{If plot.type=F, a list of midpoint and est, the heights.
}
\description{computes and plots a histogram
}
\seealso{\code{\link{hist}}, \code{\link{frequency.polygon}}, \code{\link{histogram.normal.ref}}}
)
\examples{
data(buffalo)
# Figure 1.9
histogram(buffalo,10,0)

# Figure 1.16
par(mfrow=c(3,2))
histogram(buffalo,10,0)
histogram(buffalo,10,2)
histogram(buffalo,10,4)
histogram(buffalo,10,6)
histogram(buffalo,10,8)
grid <- 1+seq(20,138,2)
est<-numeric(length(grid))
for(i in seq(0,8,2)){
      cw <- histogram(buffalo,10,i,FALSE)
      est <- est+cw[[2]][(grid-i)\%/\%10]/5
}
barplot(est,grid[-1]-grid[-length(grid)],space=0,ylim=c(0,max(est)))
box()
}
\references{`Smoothing Techniques with Implementation in S', Wolfgang Haerdle,
Springer, 1991
}
