Cv.warping<-function(x,delta,kernel,Mstart=1,Mend)
{
  x<-x[!is.na(x)]
# selection of missing values
  if (missing(Mend)) Mend<-floor(0.33*diff(range(x))/delta)
  Mnumber<-Mend-Mstart+1
# Maximal value of smoothing parameter h about a third part
# of the range of x
  numdata<-length(x)
  start<-min(x)-delta*(Mend+0.1)
  origin<-(floor(start/delta)-0.5)*delta
  numbin<-ceiling((max(x)+delta*(Mend+0.1)-origin)/delta)+1
  max.notempty<-min(numdata+1,numbin)
# Creation of several vectors needed in the C-routine
# Call of the C-routine
  z<-.C("cvwarping",
    as.double(x),
    double(numbin),
    as.double(delta),
    as.integer(c(Mstart,Mend)),
  result=double(Mnumber),
    double(Mend),
    as.double(origin),
    integer(numbin),
    integer(max.notempty),
    integer(max.notempty),
    as.integer(numdata),
    as.integer(numbin),
    as.integer(kernel))$result
# Creation of a matrixm which contains in the first column
# the vector of the used M, the second the corresponding 
# CV-values.  Note that the corresponding bandwidths h are
# computed by multiplying the first column with delta.
#
  cv<-matrix(c(c(Mstart:Mend),z),Mnumber,2)
# This matrix will be returned to S
  cv
}
  
