/* Adjusted prediction error G(M) for the WARPing-		*/
/* approximation of the NADARAYA-WATSON estimate		*/
#include <stdio.h>
#include <math.h>
double selector1 (u,v)		/* Shibata's model selector	*/
double u,v;
/* u <==> K(0), v <==> fM */
{
  double w;
  w=1+2*u/v;
  return(w);
}
double selector2 (u,v)		/* Generalised Cross-Validation	*/
double u,v;
{
  double w;
  w=pow(1.0-u/v,-2.0);
  return(w);
}
double selector3 (u,v)		/* Akaike's Information Criterion */
double u,v;
{
  double w;
  w=exp(2*u/v);
  return(w);
}
double selector4 (u,v)		/* Finite Prediction Error	*/
double u,v;
{
  double w;
  w=(1.0+u/v)/(1.0-u/v);
  return(w);
}
double selector5 (u,v)		/* Rice's T			*/
double u,v;
{
  double w;
  w=1.0/(1.0-2.0*u/v);
  return(w);
}

Gwarpingreg(x,y,delta,rangeM,score,kwe,origin,bin,counts,ysum,ysquaresum,
index,n,numbin,kernel,select,binboundary,indexweight)
/* x <==> 1 dim predictor					*/
/* y <==> 1 dim response					*/
/* delta <==> binwidth						*/
/* rangeM <==> range of smoothing parameter M			*/
/* score <==> value of the score function			*/
/* kwe <==> weights depending on the different kernels		*/
/* origin <==> left boundary of first bin			*/
/* bin <==> flag for non-empty bins				*/
/* counts <==> counts in non-empty bins				*/
/* ysum <==> sum of response-observations in non-empty bins	*/
/* ysquaresum <==> sum of squared response in non-empty bins	*/
/* index <==> index of non-empty bins				*/
/* n <==> number of observations				*/
/* numbin <==> total number of small bins 			*/
/* kernel <==> 	type of kernel coded from 1 to 5		*/
/* select <==> 	 type of selection function coded 1 to 5	*/
/* binboundary <==> index of first and last bin with weight 1	*/
/* indexweight <==> index of non-empty bins with weight 1	*/
double *x,*y,*delta,*score,*kwe,*origin,*ysum,*ysquaresum;
long *rangeM,*bin,*counts,*index,*n,*numbin,*kernel,*select,
	*binboundary,*indexweight;
{
  double mM,rM,fM,term1,term2;
  long index2,nl,nlweight;
  register long M,i,j,k;
  double(*selector)();
  nl=0;
  nlweight=0;
  switch ( *select)
  {
    case 1: selector=selector1; break;
    case 2: selector=selector2; break;
    case 3: selector=selector3; break;
    case 4: selector=selector4; break;
    case 5: selector=selector5; break;
    default:
    printf("Error in the choice of selector !");return;
  }
/* BINNING THE DATA */
  for (i=0;i<n[0];i++)
  {
    j=floor((x[i]-origin[0])/(*delta));
    if (bin[j]==0) /* first observ. in bin */
    {
      ++nl;
      counts[nl]=1;
      ysum[nl]=y[i];
      ysquaresum[nl]=pow(y[i],2.0);
      index[nl]=j;
      bin[j]=nl;
      if ((j>=binboundary[0]) && ( j<=binboundary[1]))
      {
        ++nlweight;
        indexweight[nlweight]=nl;
      }
    }
    else
    {
      counts[bin[j]]++;
      ysum[bin[j]]+=y[i];
      ysquaresum[bin[j]]+=pow(y[i],2.0);
    }
  }
  for (M=rangeM[0];M<(rangeM[1]+1);M++)
  {
/* CREATING WEIGHTS */
/* NOTE WEIGHTS ARE NOT NORMALISED */
    switch ( *kernel )
    {
      case 1 : for (i=0;i<M;i++)
        kwe[i]=1;
        break;
      case 2 : for (i=0;i<M;i++)
        kwe[i]=1.0-(double)i/(double)M;
        break;
      case 3 : for (i=0;i<M;i++)
        kwe[i]=1.0-pow((double)i/(double)M, 2.0);
        break;
      case 4 : for (i=0;i<M;i++)
        kwe[i]=pow(1.0-pow((double)i/(double)M,2.0),2.0);
        break;
      case 5 : for (i=0;i<M;i++)
        kwe[i]=pow(1.0-pow((double)i/(double)M,2.0),3.0);
        break;
      default: 
        printf("error in the choice of kernel %d!", *kernel);
        return;
    }
    for (j=1;j<nlweight+1;j++)
    {
 /* these were never set, so the first M value was rubbish */
      rM=0;
      fM=0;
      k=indexweight[j];
      for (i=1-M;i<M;i++)
      {
        index2=bin[index[k]+i];
        if(index2>0)
        {
          rM += kwe[abs(i)]*ysum[index2];
          fM += kwe[abs(i)]*counts[index2];
        }
      }
      mM=rM/fM;
      term1=ysquaresum[k]-2*mM*ysum[k]+counts[k]*pow(mM,2.0);
      term2=(*selector)(kwe[0],fM);
      score[M-rangeM[0]]+=term1*term2;
   /* Initialize moved to top of loop */
    } /* end for j */
  } /* end for M */
} /* end*/
