# WARPing density estimation in S
# expected parameter : data x, bandwidth h, number of
# small bins M and the chosen kernel, coded by 1 up to 5.
# 1 = Uniform, 2 = Triangle (ASH), 3 = Epanechnikov,
# 4 = Quartic, 5 = Triweight
#
warping.old  <-function(x,h,M,kernel)
{
x <-x[!is.na(x)]
# selection of missing values
n <-length(x)
delta <-h/M
# delta is the binwidth of the small bins
numbin<-floor((max(x)-min(x))/delta)+2*(M+1+ceiling(M/10))
start<-min(x)-h-delta*0.1
origin<-(floor(start/delta)-0.5)*delta
# origin is left border of first bin
# This form has been chosen to make sure that the
# interval, where the density will be estimated, begins
# nearly atmin(x)-h and ends nearly at max(x)+h.
#
max.notempty<-min(n+1,numbin)
# The number of non-empty bins is bounded by the number of
# observations and the number of the considered small bins
# Initial the C-routine
# Call of the C-routine
z<-.C("warping",
as.double(x),
result=  double(numbin),
as.double(h),
double(M),
as.double(origin),
integer(numbin),
integer(max.notempty),
integer(max.notempty),
as.integer(M),
as.integer(n),
as.integer(kernel))$result
# C-routine returns vector z with estimates
#
# Creation of a matrix, which contains in the first column
# a vector with the bin-midpoints and in the second column
# the belonging estimates.
#
warp<-matrix(0,numbin,2)
warp[,1]<-(0.5+c(0:(numbin-1)))*delta+origin
warp[,2]<-z
# This matrix will be returned to S.
warp
} 


