G.Warpingreg<-function(x,y,delta,selector=2,kernel=4,Mstart=5,Mend,boundary=0.1)
# S-function calling the C-routine for computation of
# the adjusted prediction error G(M) for WARPing regression
#
# Expected parameters :
# Predictor x (onedimensional) and response y.
# Binwidth delta
# Optional parameters :
# Selector coded 1 to 5
# 1 : SHIBATA'S MODEL SELECTOR
# 2 : GENERALIZED CROSS-VALIDATION (default)
# 3 : AKAIKE'S INFORMATION CRITERION
# 4 : FINITE PREDICTION ERROR
# 5 : RICE'S T
# Kernel ( default 4 Quartic)
# Start and end point for the smoothing parameter M,
# default is 5 (not 1 to reduce binning effects).
# and 0.3*range(data)/delta
# Boundary : roughly the proportion of observations
# at the boundary ignored in the computation.
{
  if(missing(Mend)) Mend<-floor(0.3*diff(range(x))/delta)
  Mnumber<-Mend-Mstart+1
  numdata<-length(x)
  start<-min(x)-delta*(Mend+0.1)
  origin<-(floor(start/delta)-0.5)*delta
  numbin<-ceiling((max(x)+delta*(Mend+0.1)-origin)/delta)+1
# definition of weight function as an indexfunction, which is
# zero for bins at (and outside) the boundary of x
  binboundary<-floor((quantile(x,c(boundary/2,1-boundary/2))-origin)/delta)
  max.notempty<-min(numdata+1,numbin)
# Creation of several vectors needed in the C-routine
# Call of the C-routine
  z<-.C("Gwarpingreg",
    as.double(x),
    as.double(y),
    as.double(delta),
    as.integer(c(Mstart,Mend)),
    result=double(Mnumber),
    double(Mend),
    as.double(origin),
    integer(numbin),
    integer(max.notempty),
    double(max.notempty),
    double(max.notempty),
    integer(max.notempty),
    as.integer(numdata),
    as.integer(numbin),
    as.integer(kernel),
    as.integer(selector),
    as.integer(binboundary),
    integer(max.notempty))$result
  z<-z/numdata
  result<-list(M=c(Mstart:Mend),score=z,h=c(Mstart:Mend)*delta)
  result
}
