/* src/ash.f -- translated by f2c (version 19950110).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/*ash.f----------------------------------------------------------------------
*/
/*       April 8, 1986 */

/*       Find bin counts of data array "x(n)" for ASH estimator */

/*       "nbin" bins are formed over the interval [a,b) */

/*      bin counts returned in array "nc"  -  # pts outside [a,b) = "nskip"*/
/* ##### Copyright 1986 David W. Scott */
/* Subroutine */ int bin1_(x, n, ab, nbin, nc, nskip)
doublereal *x;
integer *n;
doublereal *ab;
integer *nbin, *nc, *nskip;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static doublereal a, b, d;
    static integer i, k;

    /* Parameter adjustments */
    --x;
    --ab;
    --nc;

    /* Function Body */
    *nskip = 0;
    a = ab[1];
    b = ab[2];
    i__1 = *nbin;
    for (i = 1; i <= i__1; ++i) {
	nc[i] = 0;
/* L5: */
    }
    d = (b - a) / *nbin;
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	k = (integer) ((x[i] - a) / d + (float)1.);
	if (k >= 1 && k <= *nbin) {
	    ++nc[k];
	} else {
	    ++(*nskip);
	}
/* L10: */
    }
    return 0;
} /* bin1_ */

/*       April 8, 1986 */

/*       Computer ASH density estimate;  Quartic (biweight) kernel */

/*       Average of "m" shifted histograms */

/*       Bin counts in array "nc(nbin)"  -  from routine "bin1" */

/*       "nbin" bins are formed over the interval [a,b) */

/*       ASH estimates returned in array "f(nbin)" */

/*       FP-ASH plotted at  a+d/2 ... b-d/2   where d = (b-a)/nbin */

/*      Note:  If "nskip" was nonzero, ASH estimates incorrect near boundary*/
/*      Note:  Should leave "m" empty bins on each end of array "nc" so f OK*/
/* ##### Copyright 1986 David W. Scott */
/* Subroutine */ int ash1_(m, nc, nbin, ab, kopt, t, f, w, ier)
integer *m, *nc, *nbin;
doublereal *ab;
integer *kopt;
doublereal *t, *f, *w;
integer *ier;
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4, i__5, i__6;
    real r__1, r__2, r__3;

    /* Builtin functions */
    double pow_ri();

    /* Local variables */
    static real cons, a, b, c;
    static doublereal h;
    static integer i, k, n;
    static doublereal delta;
    static real xm;
    static integer mm1;

    /* Parameter adjustments */
    --w;
    --f;
    --t;
    --nc;
    --ab;
    --kopt;

    /* Function Body */
    *ier = 0;
    a = ab[1];
    b = ab[2];
    n = 0;
/* -compute weights    cons * ( 1-abs((i/m))^kopt1)^kopt2 */
/*             --  should sum to "m"   5-8-91 */
/*                       w-array shifted by 1 */
    mm1 = *m - 1;
    xm = (real) (*m);
/*                    cons = sum of weights from -(m-1) to (m-1) = 1 + 2 (
sum from 1 to m-1)*/
    w[1] = (float)1.;
    cons = (float)1.;
    i__1 = mm1;
    for (i = 1; i <= i__1; ++i) {
	r__3 = (r__1 = i / xm, dabs(r__1));
	r__2 = (float)1. - pow_ri(&r__3, &kopt[1]);
	w[i + 1] = pow_ri(&r__2, &kopt[2]);
	cons += w[i + 1] * 2;
/* L5: */
    }
    cons = (real) (*m) / cons;
    i__1 = *m;
    for (i = 1; i <= i__1; ++i) {
	w[i] = cons * w[i];
/* L6: */
    }
/* -check if estimate extends beyond mesh */
    i__1 = mm1;
    for (i = 1; i <= i__1; ++i) {
	if (nc[i] + nc[*nbin + 1 - i] > 0) {
	    *ier = 1;
	}
/* L7: */
    }
/* -compute ash(m) estimate */
    delta = (b - a) / *nbin;
    h = *m * delta;
    i__1 = *nbin;
    for (i = 1; i <= i__1; ++i) {
	t[i] = a + (i - (float).5) * delta;
	f[i] = (float)0.;
	n += nc[i];
/* L10: */
    }
    i__1 = *nbin;
    for (i = 1; i <= i__1; ++i) {
	if (nc[i] == 0) {
	    goto L20;
	}
	c = nc[i] / (n * h);
/* Computing MAX */
	i__2 = 1, i__3 = i - mm1;
/* Computing MIN */
	i__5 = *nbin, i__6 = i + mm1;
	i__4 = min(i__5,i__6);
	for (k = max(i__2,i__3); k <= i__4; ++k) {
	    f[k] += c * w[(i__2 = k - i, abs(i__2)) + 1];
/* L15: */
	}
L20:
	;
    }
    return 0;
} /* ash1_ */

/*       April 12, 1986          bin2.f */

/*       Find bin counts of data array "x(n,2)" for ASH estimator */

/*       "nbin1" by "nbin2" bins are formed */

/*       x:axis  [ ab(1,1) , ab(1,2) ) */
/*       y:axis  [ ab(2,1) , ab(2,2) )   half-open */

/*      bin counts returned in array "nc"  -  # pts outside [a,b) = "nskip"*/
/* ##### Copyright 1986 David W. Scott */
/* Subroutine */ int bin2_(x, n, ab, nbin1, nbin2, nc, nskip)
doublereal *x;
integer *n;
doublereal *ab;
integer *nbin1, *nbin2, *nc, *nskip;
{
    /* System generated locals */
    integer x_dim1, x_offset, nc_dim1, nc_offset, i__1, i__2;

    /* Local variables */
    static integer i, j;
    static doublereal ax;
    static real bx;
    static doublereal by, dx, dy;
    static real ay;
    static integer kx, ky;

    /* Parameter adjustments */
    x_dim1 = *n;
    x_offset = x_dim1 + 1;
    x -= x_offset;
    ab -= 3;
    nc_dim1 = *nbin1;
    nc_offset = nc_dim1 + 1;
    nc -= nc_offset;

    /* Function Body */
    *nskip = 0;
    ax = ab[3];
    bx = ab[5];
    ay = ab[4];
    by = ab[6];
    i__1 = *nbin2;
    for (j = 1; j <= i__1; ++j) {
	i__2 = *nbin1;
	for (i = 1; i <= i__2; ++i) {
	    nc[i + j * nc_dim1] = 0;
/* L4: */
	}
/* L5: */
    }
    dx = (bx - ax) / *nbin1;
    dy = (by - ay) / *nbin2;
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	kx = (integer) ((x[i + x_dim1] - ax) / dx + (float)1.);
	ky = (integer) ((x[i + (x_dim1 << 1)] - ay) / dy + (float)1.);
	if (kx >= 1 && kx <= *nbin1 && ky >= 1 && ky <= *nbin2) {
	    ++nc[kx + ky * nc_dim1];
	} else {
	    ++(*nskip);
	}
/* L10: */
    }
    return 0;
} /* bin2_ */

/*       April 12, 1986          ash2.f */

/*       Computer ASH density estimate;  Product Quartic (biweight) kernel */

/*       Average of "m[1] by m[2]" shifted histograms */

/*       Bin counts in matrix "nc"  -  from routine "nbin2" */

/*       ASH estimates returned in matrix "f" */

/*       FP-ASH plotted at  a+d/2 ... b-d/2   where d = (b-a)/nbin */

/*      Note:  If "nskip" was nonzero, ASH estimates incorrect near boundary*/
/*      Note:  Should leave "m" empty bins on each end of array "nc" so f OK*/
/* #### Copyright 1986 David W. Scott */
/* #### added kernel option kopt 5-8-91 */
/* Subroutine */ int ash2_(m1, m2, nc, nbinx, nbiny, ab, kopt, f, w, ier)
integer *m1, *m2, *nc, *nbinx, *nbiny;
doublereal *ab;
integer *kopt;
doublereal *f, *w;
integer *ier;
{
    /* System generated locals */
    integer f_dim1, f_offset, w_dim1, w_offset, nc_dim1, nc_offset, i__1, 
	    i__2, i__3, i__4, i__5, i__6, i__7, i__8;
    real r__1, r__2, r__3;

    /* Builtin functions */
    double pow_ri();

    /* Local variables */
    static real c;
    static integer i, j, n;
    static real consx, consy, ax, bx, ay, by;
    static integer ncheck;
    static real dx, dy, hx, hy;
    static integer kx, ky, mx, my;
    static real xm, ym;
    static integer mxm1, mym1;

    /* Parameter adjustments */
    w_dim1 = *m1;
    w_offset = w_dim1 + 1;
    w -= w_offset;
    f_dim1 = *nbinx;
    f_offset = f_dim1 + 1;
    f -= f_offset;
    nc_dim1 = *nbinx;
    nc_offset = nc_dim1 + 1;
    nc -= nc_offset;
    ab -= 3;
    --kopt;

    /* Function Body */
    *ier = 0;
    ax = ab[3];
    bx = ab[5];
    ay = ab[4];
    by = ab[6];
/* -compute weights    cons * ( 1-abs(i/m)^kopt1)^kopt2 */
/*           --  should sum to "m"   5-8-91 */
/*                       w-array shifted by 1 */
    mx = *m1;
    my = *m2;
    mxm1 = mx - 1;
    mym1 = my - 1;
    xm = (real) mx;
    ym = (real) my;
/* -----ASSUMES f dimensioned larger than m1 or m2 */
/* -put marginal weights in f array as work array */
    f[f_dim1 + 1] = (float)1.;
    f[f_dim1 + 2] = (float)1.;
/*      consx = sum of weights from -(m-1) to (m-1) = 1 + 2 (sum from 1 to
 m-1)*/
    consx = (float)1.;
    consy = (float)1.;
    i__1 = mxm1;
    for (i = 1; i <= i__1; ++i) {
	r__3 = (r__1 = i / xm, dabs(r__1));
	r__2 = (float)1. - pow_ri(&r__3, &kopt[1]);
	f[(i + 1) * f_dim1 + 1] = pow_ri(&r__2, &kopt[2]);
	consx += f[(i + 1) * f_dim1 + 1] * 2;
/* L5: */
    }
    consx = (real) mx / consx;
    i__1 = mym1;
    for (i = 1; i <= i__1; ++i) {
	r__3 = (r__1 = i / ym, dabs(r__1));
	r__2 = (float)1. - pow_ri(&r__3, &kopt[1]);
	f[(i + 1) * f_dim1 + 2] = pow_ri(&r__2, &kopt[2]);
	consy += f[(i + 1) * f_dim1 + 2] * 2;
/* L6: */
    }
    consy = (real) my / consy;
/* -computer product weight array (avoids later multiplications) */
    i__1 = my;
    for (j = 1; j <= i__1; ++j) {
	i__2 = mx;
	for (i = 1; i <= i__2; ++i) {
	    w[i + j * w_dim1] = consx * f[i * f_dim1 + 1] * (consy * f[j * 
		    f_dim1 + 2]);
/* L2: */
	}
/* L3: */
    }
/* -compute ash(m) estimate */
    n = 0;
    i__1 = *nbiny;
    for (j = 1; j <= i__1; ++j) {
	i__2 = *nbinx;
	for (i = 1; i <= i__2; ++i) {
	    f[i + j * f_dim1] = (float)0.;
	    n += nc[i + j * nc_dim1];
/* L9: */
	}
/* L10: */
    }
/* -check if estimate extends beyond mesh */
    ncheck = 0;
    i__1 = *nbiny + 1 - my;
    for (j = my; j <= i__1; ++j) {
	i__2 = *nbinx + 1 - mx;
	for (i = mx; i <= i__2; ++i) {
	    ncheck += nc[i + j * nc_dim1];
/* L11: */
	}
/* L12: */
    }
    if (ncheck != n) {
	*ier = 1;
    }
    dx = (bx - ax) / *nbinx;
    dy = (by - ay) / *nbiny;
    hx = mx * dx;
    hy = my * dy;
    i__1 = *nbiny;
    for (j = 1; j <= i__1; ++j) {
	i__2 = *nbinx;
	for (i = 1; i <= i__2; ++i) {
	    if (nc[i + j * nc_dim1] == 0) {
		goto L19;
	    }
	    c = nc[i + j * nc_dim1] / (n * hx * hy);
/* Computing MAX */
	    i__3 = 1, i__4 = j - mym1;
/* Computing MIN */
	    i__6 = *nbiny, i__7 = j + mym1;
	    i__5 = min(i__6,i__7);
	    for (ky = max(i__3,i__4); ky <= i__5; ++ky) {
/* Computing MAX */
		i__3 = 1, i__4 = i - mxm1;
/* Computing MIN */
		i__7 = *nbinx, i__8 = i + mxm1;
		i__6 = min(i__7,i__8);
		for (kx = max(i__3,i__4); kx <= i__6; ++kx) {
		    f[kx + ky * f_dim1] += c * w[(i__3 = kx - i, abs(i__3)) + 
			    1 + ((i__4 = ky - j, abs(i__4)) + 1) * w_dim1];
/* L17: */
		}
/* L18: */
	    }
L19:
	    ;
	}
/* L20: */
    }
    return 0;
} /* ash2_ */

