\name{kdesign.greedy}
\alias{kdesign.greedy}
\title{Design for kriging (greedy heuristic)}
\description{
      Determining an initial solution by a greedy algorithm for the
    construction of spatial designs minimizing the maximum or the mean
    of the occuring krige variances.
  
 Starting point is a network with \eqn{nf} fixed points. The task is the
 optimal expansion of the existing network by \eqn{ns} points of a set
 of \eqn{ne} eligible stations. 
}
\usage{
kdesign.greedy(point.obj, eligible.obj, ns, at, var.mod.obj,
        xsw=NULL, ysw=NULL, xne=NULL, yne=NULL, dx=NULL, dy=NULL,
        angle=NULL, maxdist=NULL, extrap=FALSE, border=NULL, trend=0,
        rsearch=0, nsearch=0, nsmin=-1, nsmax=-1,
        pgrid=1,criterion="meanvar", verbose=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
 \item{point.obj}{ Object of class \code{"point"}, generated by
   \code{\link[sgeostat]{point}} from the \code{library(sgeostat)} representing the
   existing network with \eqn{nf} stations.}
 \item{eligible.obj}{Object of class \code{"point"}, generated by
   \code{\link[sgeostat]{point}} from the \code{library(sgeostat)} representing the
   eligible points with \eqn{ne} stations. }
 \item{ns}{Number of stations have to be added to the existing
   network.}
 \item{at}{The variable, contained in \code{point.obj}, for which
   prediction will be carried out.}
 \item{var.mod.obj}{ Object of class \code{"variogram.model"} generated
   by \code{\link[sgeostat]{fit.variogram}} from the \code{library(sgeostat)}.}
  \item{xsw}{\eqn{x} coordinate of the south west corner of the
   prediction grid, else the prediction grid is generated automatically
   (default NULL).}
 \item{xne}{\eqn{x} coordinate of the north east corner of the
   prediction grid, else the prediction grid is generated automatically 
   (default NULL). }
  \item{ysw}{\eqn{y} coordinate of the south west corner of the
   prediction grid, else the prediction grid is generated automatically
   (default NULL).}
 \item{yne}{\eqn{y} coordinate of the north east corner of the
   prediction grid, else the prediction grid is generated automatically 
   (default NULL). }
 \item{dx}{Grid spacing in \eqn{x} direction, else it is automatically
   generated by the function (default NULL).}
 \item{dy}{Grid spacing in \eqn{y} direction, else it is automatically
   generated by the function (default NULL). }
  \item{angle}{ Parameter for rotating the grid (currently unimplemented). }
 \item{maxdist}{An optional maximum distance. If entered, then only
   sample points (i.e, in \code{point.obj}) within \code{maxdist} of
   each prediction point will be used to do the prediction at that
   point. If not entered, then all \eqn{n} sample points will be used to
     make the prediction at each point. }
 \item{extrap}{Logical, indicates if prediction outside the convex hull
   of data points  should be done, default \code{FALSE}.}
  \item{border}{ optional: restrict computation to points within a
    closed polygon, given as a list with two members \code{x} and \code{y}}
  \item{trend}{ The parameter \code{trend} indicates the trend behaviour
   of the underlying stochastic process (0: no trend (default), 1:
   linear trend, 2: quadratic trend). }
 \item{rsearch}{Fixed radius for search neighbourhood (use either
   \code{rsearch} or \code{nsearch}).}
 \item{nsearch}{Fixed cardinality for search neighbourhood (use either
   \code{rsearch} or \code{nsearch}). }
  \item{nsmin}{ Minimum number of points in search
   neighbourhood (applies additionally to \code{rsearch} or \code{nsearch}).}
 \item{nsmax}{ Maximum number of points in search
   neighbourhood (applies additionally to \code{rsearch} or \code{nsearch}).}
 \item{pgrid}{Parameter for automatically generating the grid. If
   \code{pgrid} is 1 the prediction grid is generated using all given
   points (default). If \code{pgrid} is 2, for the prediction grid only the 
   eligible points are treated.}
   \item{criterion}{One of \code{maxvar} (maximum of the krige variances),
   \code{meanvar} (default, mean of the krige variances). Indicates
   which criterion is to be minimized.}
 \item{verbose}{for debugging}
}
\value{
  \item{x}{\eqn{x} locations of the grid points.}
  \item{y}{\eqn{y} locations of the grid points.}
  \item{var}{Krige variances occuring for the solution obtained by the
    greedy heuristic.}
  \item{S}{Vector containing the indices of the added sites in the
    solution obtained by the greedy heuristic.}
    \item{objective}{Value of the objective function for the greedy solution.} 
}
\author{ C. Gebhardt }
\note{ \code{x}, \code{y} and \code{var} are suitable for plotting methods like
  \code{\link{image}} or \code{\link{contour}}. }

\seealso{ \code{\link{kdesign.cenum}}, \code{\link{kdesign.dualgreedy}}, \code{\link{kdesign.cov}}}

\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	     or do  help(data=index)  for the standard data sets.
}
\keyword{ spatial }%-- one or more ...
\keyword{ design }%-- one or more ...
