"optim.tpsreg"<-
function(tpsreg.object, start, x.scale, maximize = T, lower =  - Inf, upper = 
	Inf, ...)
{
	if(maximize)
		f <- function(x, tpsreg.object)
		{
			x <- matrix(x, nrow = 1, dimnames = list(1, dimnames(
				tpsreg.object$x)[[2]]))
			y <-  - predict(tpsreg.object, x)
			y
		}
	else f <- function(x, tpsreg.object)
		{
			x <- matrix(x, nrow = 1, dimnames = list(1, dimnames(
				tpsreg.object$x)[[2]]))
			predict(tpsreg.object, x)
		}
	x <- matrix(start, nrow = 1, dimnames = list(1, dimnames(tpsreg.object$
		x)[[2]]))
	predict(tpsreg.object, x)
	if(!missing(x.scale))
		for(i in 1:length(start)) {
			a <- min(x.scale[, i])
			b <- max(x.scale[, i])
			start[i] <- (start[i] - a)/(b - a)
			if(length(lower) > 1)
				lower[i] <- (lower[i] - a)/(b - a)
			if(length(upper) > 1)
				upper[i] <- (upper[i] - a)/(b - a)
		}
	optim.out <- nlminb(start, f, tpsreg.object = tpsreg.object, upper = 
		upper, lower = lower, ...)
	if(!missing(x.scale))
		for(i in 1:length(optim.out$par)) {
			a <- min(x.scale[, i])
			b <- max(x.scale[, i])
			optim.out$par[i] <- optim.out$par[i] * (b - a) + a
		}
	optim.out$aux <- NULL
	optim.out
}
