"lft.tps"<-
function(tps.obj = test)
{
	tps.obj.parm <- tps.parm(tps.obj)
	nam <- row.names(tps.obj.parm)[-1]
	form <- as.formula(paste("y~", paste(nam, collapse = "+")))
	y <- tps.obj$y
	data.f <- data.frame(tps.obj$x, y)
	print(form)
	lmout <- lm(form, data = data.f)
	sse.lm <- sum(lmout$residuals^2)
	df.lm <- lmout$df.residual
	sse.tps <- sum(tps.obj$residuals^2)
	df.tps <- tps.obj$N - tps.obj$eff.df
	ts <- ((sse.lm - sse.tps)/(df.lm - df.tps))/(sse.tps/df.tps)
	F.95 <- qf(0.94999999999999996, (df.lm - df.tps), df.tps)
	list(ts = ts, F.95 = F.95)
}
