"kernel.cov.RSS"<-
function(cov.mat, loc, cov.function = exp.isocor, rho = 1, M = 5, ...)
{
# find difference between correlation matrix and that estimated by
# isotropic exponential model. 
#
# fit surface to marginal standard deviations. 
#
# add passed arguments to the covariance function
#
#
	temp <- eigen(cov.mat - rho * cov.function(loc, loc, ...))	
	# eigen vector-eigenvalue decomposition of correlation matrix minus
# the parametric  covariance defined by cov.function
#
#
	temp.e <- temp$values
	e.neg <- min(temp.e[temp.e < 0])
	if(is.na(e.neg)) e.neg <- 0	
	#	cat(" first eigenvalue", temp.e[1], fill = T)
#	cat("most  negative is ", e.neg, fill = T)	##
###
	if(temp.e[M] < abs(e.neg)) {
		M <- sum(temp.e > abs(e.neg))
		if(M > 1)
			warning(" Some negative eigenvalues found! M has been reset "
				)
		else {
			warning("Largest eigenvalue in absolute value is negative!"
				)
			upper <- col(cov.mat) >= row(cov.mat)
			return(sum((cov.mat - rho * cov.function(loc, loc, ...)
				)[upper]^2))
		}
	}
#
# calculate residuals
#
	U <- temp$vectors
	upper <- col(cov.mat) >= row(cov.mat)
	sum(((U[,  - (1:M)] %*% (temp$values[ - (1:M)] * t(U[,  - (1:M)])))^2)[
		upper])	# 
}
