"FMPinv"<-
function(X)
{
# Generalized inverse of symmetric X
	Xeig <- eigen(X, symmetric = T)
	Xval <- Xeig$values
	ipos <- Xval > 1e-08
	if(sum(ipos) > 1) {
		X1 <- Xeig$vectors[, ipos] %*% diag(1/Xval[ipos]) %*% t(Xeig$
			vectors[, ipos])
	}
	else {
		if(sum(ipos) == 1) {
			X1 <- Xeig$vectors[, ipos] %*% matrix(Xeig$vectors[, 
				ipos], nrow = 1)/Xval[ipos]
		}
		else {
			X1 <- matrix(0, nrow(X), ncol(X))
		}
	}
	Xeig <- eigen(X1, symmetric = T)
	Xsel <- abs(Xeig$values) < 100000000
	X1 <- Xeig$vectors[, Xsel] %*% diag(Xeig$values[Xsel]) %*% t(Xeig$
		vectors[, Xsel])
	return(X1)
}
