"format.help"<-
function(name = "help", tfile = NA, message = T)
{
	if(!missing(name) && is.name(sname <- substitute(name)) && !(exists(
		as.character(sname)) && is.character(name) && length(name) == 1
		))
		name <- substitute(name)	# name is not yet evaluated
	if(is.language(name) && !is.name(name))
		name <- eval(name)
	name <- as.character(name)
	if(length(name) != 1) {
		warning("Can only get help on one item at a time")
		name <- name[1]
	}
	if(name == "")
		name <- "help"
	unquoted.name <- name
	name <- paste("'", name, "'", sep = "")
	search.list <- paste("'", search(), "'", sep = "", collapse = " ")
	if(is.na(tfile))
		tfile <- paste(substitute(name), ".txt", sep = "")
	cmd <- paste("$SHOME/cmd/help", name, search.list, ">   ", tfile)
	if(unix(cmd, output = F) != 0) {
		unix(paste(" rm  ", tfile))
		cat("No documentation available for ", name, "\n", sep = "")
		invisible(return(F))
	}
	if(message)
		cat("Formated help  written to ", tfile, fill = T)
	return(T)
	invisible()
}
