C*** Declaration of the variables 
      PARAMETER (MAXCAND=20000,MAXDES=400,MAXCOL=20) 
      PARAMETER (MAXR=MAXCAND*MAXCOL,MAXHIS=10000*3) 
      INTEGER ND,NT,NROW,NCOL,NUM,NCROW,MAXLOOP
      INTEGER NDSET(MAXDES),NLOOP,iP,iQ
      CHARACTER NN 
      DOUBLE PRECISION R(maxr)
      DOUBLE PRECISION HIST(MAXHIS)
C***  OPEN DEVICES      
      OPEN(17,FILE='R.tmp',STATUS='unknown')
      OPEN(18,FILE='c.tmp',STATUS='unknown')
      OPEN(19,FILE='Dset.tmp',STATUS='unknown')
      OPEN(20,FILE='output',STATUS='unknown')
      OPEN(30,FILE='loop.out',STATUS='unknown')
C***  Reading required informations
      READ(18,*) ND
      READ(18,*) NROW
      READ(18,*) NCOL
      READ(18,*) iP
      READ(18,*) iQ
      READ(18,*) NN
      READ(18,*) NUM
      READ(18,*) NT
      READ(18,*) NCROW
      READ(18,*) MAXLOOP
      
      READ(17,*) (R(I),I=1,NROW*NCOL)
      READ(19,*) (NDSET(K),K=1,NT)

      CALL COVERLP(ND,NT,NROW,NCROW,NCOL,NUM,NN,NHIST,iP,iQ,R,
     +     NDSET,NLOOP,HIST,MAXLOOP)  

      WRITE(20,*) (NDSET(L),L=1,NT)
      WRITE(20,*) NHIST
      WRITE(20,*) NLOOP
      WRITE(20,100) (HIST(L),L=1,NHIST*3)
 100  FORMAT(3(F16.7))
      CLOSE(UNIT=17)
      CLOSE(UNIT=18)
      CLOSE(UNIT=19)
      CLOSE(UNIT=20)
      STOP
      END
c**** subroutine for the ordering
      SUBROUTINE ORDER(NT,K,IND)
      INTEGER NT,IND(NT),K(NT),iTEMP,iTOP,iVALUE
      DO J=1,NT
         IND(J)=J
      ENDDO
      DO iTOP=1,NT-1
         iVALUE=K(IND(iTOP))
         DO L=iTOP,NT
            IF(K(IND(L)) .LT. iVALUE) THEN
               iTEMP=IND(L)
               IND(L)=IND(iTOP)
               IND(iTOP)=iTEMP
               iVALUE = K(IND(iTOP))
            ENDIF
         ENDDO
      ENDDO
      iTEMP=0
      RETURN
      END
C**** subroutine for making the Cset 
c***  n is the number of the design point
c***  nc is the number of the candidate point
c***  ind is the order of the design set
c***  KD is the design set and KC is Candidate set
      SUBROUTINE MAKECSET(N,NC,IND,KD,KC)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER N,NC,NORD,IND(N)
      INTEGER KD(N),KC(NC)   
      NORD=1
      DO J=1,N
         DO I=NORD,KD(IND(J))-J
            KC(I)=NORD+(J-1)
            NORD=I+1
         ENDDO
      ENDDO
      DO J=NORD,NC
         KC(J)=J+N
      ENDDO
      RETURN
      END
c*** subroutine for making the Rdset or Rcset 
c***  n is the number of the design point
c***  nc is the number of the candidate point
c***  nr is the number of total n+nc=nr
c***  no is the number of the column of the R 
c***  KD is the design set and KC is Candidate set
c***  R is the original set and RD and RC are the corresponding
c***  set of design and candidate
      SUBROUTINE MAKERSET(N,NR,NO,NC,KD,KC,R,RD,RC)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXCAND=20000,MAXDES=400,MAXCOL=20)
      PARAMETER (MAXR=MAXCAND*MAXCOL,MAXRD=MAXDES*MAXCOL)
      INTEGER N,NR,NC,NO,KD(N),KC(NC)
      REAL*8 RD(MAXRD),RC(MAXR),R(MAXR)
      NDK=0
      NRK=0
      DO I=1,NO
         DO J=1,N
            RD(NDK+J)=R(NRK+KD(J))
         ENDDO
         NDK=NDK+N
         NRK=NRK+NR
      ENDDO
      NCK=0
      NRK=0
      DO I=1,NO
         DO J=1,NC
            RC(NCK+J)=R(NRK+KC(J))
         ENDDO
         NCK=NCK+NC
         NRK=NRK+NR
      ENDDO
      RETURN
      END
C**** SUBROUTINE FOR MAKING THE RDSETi AND RDSET WITHOUT I
      SUBROUTINE MKWORDSET(I,N,NR,NO,NIJ,KD,DI,R,RDI)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXCAND=20000,MAXDES=400,MAXCOL=20)
      PARAMETER (MAXR=MAXCAND*MAXCOL,MAXRD=MAXDES*MAXCOL)
      INTEGER N,NR,NO,NIJ,KD(N),I
      REAL*8 RDI(MAXRD),R(MAXR),DI(NO)
      NRK=0
      DO J=1,NO
         DI(J)=R(NRK+KD(I))
         NRK=NRK+NR
      ENDDO
      NDK=0
      NRK=0
      DO J=1,NO
         DO K=1,I-1
            RDI(NDK+K)=R(NRK+KD(K))
         ENDDO
         DO K=I+1,N
            RDI(NDK+(K-1))=R(NRK+KD(K))
         ENDDO
         NDK=NDK+NIJ
         NRK=NRK+NR
      ENDDO
      RETURN
      END
C***  Subroutine for the calculate the residual sum of the 
C***  iP power of the distance between design pts and candidate pts
      SUBROUTINE RESIDSUM(N,NC,iP,DMAT,RS)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXCAND=20000,MAXDES=400)
      PARAMETER (MAXDIS=MAXCAND*MAXDES)
      INTEGER N,NC,iP,NDK
      REAL*8 DMAT(MAXDIS),RS(MAXCAND),TEMP
      DO I=1,NC
         RS(I)=0.0
         NDK=0
         DO J=1,N
            TEMP=1.0
            IF(iP .EQ. 8) THEN
               TEMP=(1./DMAT(NDK+I))*(1./DMAT(NDK+I))
               TEMP=TEMP*TEMP   
               RS(I)=TEMP*TEMP+RS(I)
            ELSE IF (iP .EQ. 16) THEN
               TEMP=(1./DMAT(NDK+I))*(1./DMAT(NDK+I))
               TEMP=TEMP*TEMP   
               TEMP=TEMP*TEMP   
               RS(I)=TEMP*TEMP+RS(I)
            ELSE 
               DO K=1,iP
                  TEMP=(1./DMAT(NDK+I))*TEMP
               ENDDO
               RS(I)=TEMP+RS(I)
            END IF
            NDK=NDK+NC
         ENDDO
      ENDDO
      RETURN
      END
C***  Subroutine for the calculate the partial new row
      SUBROUTINE PARTIAL(NI,iP,DMAT,PNR)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXCAND=20000)
      INTEGER NI,iP
      REAL*8 DMAT(MAXCAND),TEMP,PNR
      PNR=0.0
      DO J=1,NI
         TEMP=1.0
         IF(iP .EQ. 8) THEN
            TEMP=(1./DMAT(J))*(1./DMAT(J))
            TEMP=TEMP*TEMP
            PNR=(TEMP*TEMP)+PNR
         ELSE IF (iP .EQ. 16) THEN
            TEMP=(1./DMAT(J))*(1./DMAT(J))
            TEMP=TEMP*TEMP
            TEMP=TEMP*TEMP
            PNR=(TEMP*TEMP)+PNR
         ELSE
            DO K=1,iP
               TEMP=TEMP*(1./DMAT(J))
            ENDDO
            PNR=TEMP+PNR
         END IF
      ENDDO
      RETURN
      END
C***  Subroutine for the residual sum without ith row
      SUBROUTINE RSISUM(NC,iP,DMAT,RS,RSI)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXCAND=20000,MAXDES=400)
      INTEGER NC,iP
      REAL*8 DMAT(MAXCAND),RS(MAXCAND),RSI(MAXCAND),TEMP
      DO J=1,NC
         TEMP=1.0
         RSI(J)=0.0
         IF(iP .EQ. 8) THEN
            TEMP=(1./DMAT(J))*(1./DMAT(J))
            TEMP=TEMP*TEMP
            RSI(J)=RS(J)-(TEMP*TEMP)
         ELSE IF(iP .EQ. 16) THEN
            TEMP=(1./DMAT(J))*(1./DMAT(J))
            TEMP=TEMP*TEMP
            TEMP=TEMP*TEMP
            RSI(J)=RS(J)-(TEMP*TEMP)
         ELSE
            DO K=1,iP
               TEMP=TEMP*(1./DMAT(J))
            ENDDO
            RSI(J)=RS(J)-TEMP
         END IF
      ENDDO
      RETURN
      END
C***  subroutine for the printing the number of loop
      subroutine printlp(max,ia,iaa,ib,ibb,ic,icc)
      integer ia,iaa,ib,ibb,ic,icc
 300  format('Maximum Loop is ',i3,/'Previous Record:'/)
 400  format('Active Record:'/)
 200  format(2x,'No. of Loop:',i4,/2x,'No. of Swap:',i6,
     +     /2x,'No. of History:',i6)
      write(30,300) max
      WRITE(30,200) (ia+1),ib,ic
      write(30,400)
      write(30,200) (iaa+1),ibb,icc
C      close(unit=30)
      return
      end
C***  subroutine for the loop of the cover.design
      SUBROUTINE COVERLP(ND,NT,NROW,NCROW,NCOL,NUM,NN,NHIST,iP,iQ,R,
     +     NDSET,NLOOP,HIST,MAXLOOP)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXCAND=20000,MAXDES=400,MAXCOL=20)
      PARAMETER (MAXR=MAXCAND*MAXCOL,MAXRD=MAXDES*MAXCOL)
      PARAMETER (MAXDIS=MAXCAND*MAXDES,MAXHIS=10000*3)
      INTEGER ND,NT,NCROW,NCOL,NUM,NBESTSPOT,N1,NODER(MAXDES)
      INTEGER NDSET(MAXDES),NCSET(MAXCAND),NRDI,NRCJ,NVEC(MAXCAND)
      INTEGER iP,iQ,NLOOP,NHISTOLD,NHIST,NDSETOLD,NBEST,iHALF
      INTEGER loop,loopold,nold,noldloop,MAXLOOP
      CHARACTER NN
      REAL*8 R(MAXR),RDSET(MAXRD),RCSET(MAXR),CRITI,RDOLD(MAXCOL)
      REAL*8 DISTMAT(MAXDIS),DIST(MAXCAND),PAR(2),HIST(MAXHIS)
      REAL*8 CSETJ(MAXCOL),RCSETJ(MAXR),ANEWCOL(MAXR),CRIT(MAXCAND)
      REAL*8 CRITORG,CRITOLD,PRTNEW,RS(MAXCAND),RSWOI(MAXCAND)
      REAL*8 DSETI(MAXCOL),RDSETI(MAXRD),BEST,TEMP,POWER,RDWOI(MAXCOL)

      PAR(1)=0.5
      PAR(2)=0.0
      CALL ORDER(NT,NDSET,NODER)
      CALL MAKECSET(NT,NCROW,NODER,NDSET,NCSET)
      CALL MAKERSET(NT,NROW,NCOL,NCROW,NDSET,NCSET,R,RDSET,RCSET)
      CALL SQDIST(NCOL,RCSET,NCROW,RDSET,NT,PAR(1),DISTMAT)
      IF (iP .LT. 0) THEN
         iP= -iP
      END IF
      iHALF=INT(iP/2)
      if(iP .EQ. iQ) then
         power=1.
      else
         POWER=(FLOAT(iQ))*(1./FLOAT(iP))
      end if
      CALL RESIDSUM(NT,NCROW,iHALF,DISTMAT,RS)
      CRITI=0.0
      DO I=1,NCROW
         IF ( iP .EQ. iQ) THEN
            CRITI=(1./(RS(I)))+CRITI
         ELSE
            CRITI=(1./(RS(I)**(POWER)))+CRITI
         END IF
      ENDDO
      NHIST=1
      NLOOP=1
      CRITI=EXP((1./FLOAT(iQ))*DLOG(CRITI))
      CRITORG=CRITI
      CRITOLD=0.0
      HIST(NHIST+2)=CRITI
      BEST=1.0e10
      NBESTSPOT=1
C***  NOW THE FIRST DO LOOP START
      NRDI=NT-1
      loop=0
 100  CONTINUE
      NHISTOLD=NHIST
      DO I=1,ND
         CALL MKWORDSET(I,NT,NROW,NCOL,NRDI,NDSET,DSETI,R,RDSETI)
         CALL SQDIST(NCOL,DSETI,1,RDSETI,NRDI,PAR(1),DIST)
         PRTNEW=0.0
         CALL PARTIAL(NRDI,iHALF,DIST,PRTNEW)
         DO J=1,NRDI
            DIST(J)=0.0
         ENDDO
         CALL SQDIST(NCOL,DSETI,1,RCSET,NCROW,PAR(1),DIST)
         CALL RSISUM(NCROW,iHALF,DIST,RS,RSWOI)
         DO J=1,NCROW
            DIST(J)=0.0
         ENDDO
         IF(NN .EQ. 'T') THEN
            DO J=1,NCROW
               NVEC(J)=J
            ENDDO
C            DO TOP=1,NCROW-1
            DO TOP=1,NUM
               VALUE = DISTMAT((I-1)*NCROW+NVEC(TOP))
               DO K=TOP,NCROW
                  IF(DISTMAT((I-1)*NCROW+NVEC(K)) .LT. VALUE) THEN
                     INDEX=NVEC(K)
                     NVEC(K)=NVEC(TOP)
                     NVEC(TOP)=INDEX
                     VALUE = DISTMAT((I-1)*NCROW+NVEC(TOP))
                  END IF
               ENDDO
            ENDDO
            N1=NUM
         ELSE
            DO J=1,NCROW
               NVEC(J)=J
            ENDDO
            N1=NCROW
         END IF
C***  LOOP FOR THE NVEC
         DO J=1,N1
            NRK=0
            DO L=1,NCOL
               CSETJ(L)=R(NRK+NCSET(NVEC(J)))
               NRK=NRK+NROW
            ENDDO
            NRCJ=NCROW-1
            NCJ=0
            NCK=0
            DO M=1,NCOL
               DO L=1,NVEC(J)-1
                  RCSETJ(NCJ+L)=RCSET(NCK+L)
               ENDDO
               DO L=NVEC(J)+1,NCROW
                  RCSETJ(NCJ+(L-1))=RCSET(NCK+L)
               ENDDO
               NCJ=NCJ+NRCJ
               NCK=NCK+NCROW
            ENDDO
            CALL SQDIST(NCOL,CSETJ,1,RCSETJ,NRCJ,PAR(1),DIST)
            DO L=1,NRCJ
               TEMP=1.0
               ANEWCOL(L)=0.0
               IF (iP .EQ. 16) THEN
                  TEMP=(1./DIST(L))*(1./DIST(L))
                  TEMP=TEMP*TEMP
                  ANEWCOL(L)=TEMP*TEMP
               ELSE IF (iP .EQ. 32) THEN
                  TEMP=(1./DIST(L))*(1./DIST(L))
                  TEMP=TEMP*TEMP
                  TEMP=TEMP*TEMP
                  ANEWCOL(L)=TEMP*TEMP
               ELSE
                  DO K=1,iHALF
                     TEMP=TEMP*(1./DIST(L))
                  ENDDO
                  ANEWCOL(L)=TEMP
               END IF
               DIST(L)=0.0
            ENDDO
            CALL SQDIST(NCOL,CSETJ,1,DSETI,1,PAR(1),DIST)
            CRIT(NVEC(J))=0.0
            DO M=1,NVEC(J)-1
               IF (iP .EQ. iQ) THEN
                  CRIT(NVEC(J))=(1./(RSWOI(M)+ANEWCOL(M)))
     +                 +CRIT(NVEC(J))
               ELSE
                  CRIT(NVEC(J))=((1./(RSWOI(M)+ANEWCOL(M)))
     +                 **(POWER))+CRIT(NVEC(J))
               ENDIF
            ENDDO
            DO M=NVEC(J)+1,NCROW
               IF (iP .EQ. iQ) THEN
                  CRIT(NVEC(J))=(1./(RSWOI(M)+ANEWCOL(M-1)))
     +                 +CRIT(NVEC(J))
               ELSE
                  CRIT(NVEC(J))=((1./(RSWOI(M)+ANEWCOL(M-1)))
     +                 **(POWER))+CRIT(NVEC(J))
               ENDIF
            ENDDO
            IF (iP .EQ. iQ) THEN
               TEMP=1.0
               IF (iP .EQ. 16) THEN
                  TEMP=(1./DIST(1))*(1./DIST(1))
                  TEMP=TEMP*TEMP
                  CRIT(NVEC(J))=(CRIT(NVEC(J))+(1/((TEMP*TEMP)+
     +                 PRTNEW)))
               ELSE IF (iP .EQ. 32) THEN
                  TEMP=(1./DIST(1))*(1./DIST(1))
                  TEMP=TEMP*TEMP
                  TEMP=TEMP*TEMP
                  CRIT(NVEC(J))=(CRIT(NVEC(J))+(1/((TEMP*TEMP)+
     +                 PRTNEW)))
               ELSE
                  DO K=1,iHALF
                     TEMP=TEMP*(1./DIST(1))
                  ENDDO
                  CRIT(NVEC(J))=(CRIT(NVEC(J))+(1/(TEMP+PRTNEW)))
               END IF
               DIST(1)=0.0
            ELSE 
               TEMP=1.0
               IF (iP .EQ. 16) THEN
                  TEMP=(1./DIST(1))*(1./DIST(1))
                  TEMP=TEMP*TEMP
                  CRIT(NVEC(J))=(CRIT(NVEC(J))+(1./((TEMP*TEMP)+PRTNEW))
     +                 **(POWER))
               ELSE IF (iP .EQ. 32) THEN
                  TEMP=(1./DIST(1))*(1./DIST(1))
                  TEMP=TEMP*TEMP
                  TEMP=TEMP*TEMP
                  CRIT(NVEC(J))=(CRIT(NVEC(J))+(1./((TEMP*TEMP)+PRTNEW))
     +                 **(POWER))
               ELSE
                  DO K=1,iHALF
                     TEMP=TEMP*(1./DIST(1))
                  ENDDO
                  CRIT(NVEC(J))=(CRIT(NVEC(J))+(1./(TEMP+PRTNEW))
     +                 **(POWER))
               END IF
               DIST(1)=0.0
            END IF
            IF(BEST .GT. (CRIT(NVEC(J))**(1./FLOAT(iQ)))) THEN
               BEST=(CRIT(NVEC(J))**(1./FLOAT(iQ)))
               NBESTSPOT=NVEC(J)
            ELSE
               BEST=BEST
               NBESTSPOT=NBESTSPOT
            END IF
         ENDDO
c**** END OF THE LOOP FOR THE NVEC
         DO J=1,NCROW
            CRIT(J)=0.0
         ENDDO
         NBEST=NBESTSPOT
         NBESTSPOT=NCSET(NBESTSPOT)
         IF(BEST .LT. CRITI) THEN
            CRITOLD=CRITI
            NHISTOLD=NHIST
            CRITI=BEST
            DO L=1,3
               IF(L .EQ. 1) THEN
                  HIST(NHIST*3+L)=NDSET(I)
               ELSEIF(L .EQ. 2) THEN
                  HIST(NHIST*3+L)=NBESTSPOT
               ELSEIF(L .EQ. 3) THEN
                  HIST(NHIST*3+L)=CRITI
               ENDIF
            ENDDO
            NDSETOLD=NDSET(I)
            NDSET(I)=NBESTSPOT
            NCSET(NBEST)=NDSETOLD
            CALL MAKERSET(NT,NROW,NCOL,NCROW,NDSET,NCSET,R,RDSET,RCSET)
            NRK=0
            NDK=0
            DO J=1,NCOL
               RDWOI(J)=RDSET(NDK+I)
               RDOLD(J)=R(NRK+NDSETOLD)
               NDK=NDK+NT
               NRK=NRK+NROW
            ENDDO
            CALL SQDIST(NCOL,RDWOI,1,RCSET,NCROW,PAR(1),DIST)
            DO J=1,NCROW
               DISTMAT(((I-1)*NCROW)+J)=DIST(J)
               DIST(J)=0.0
            ENDDO
            CALL SQDIST(NCOL,RDOLD,1,RDSET,NT,PAR(1),DIST)
            NCK=0
            DO J=1,NT
               DISTMAT(NCK+NBEST)=DIST(J)
               NCK=NCK+NCROW
               DIST(J)=0.0
            ENDDO
            DO J=1,NCROW
               RS(J)=0.0
            ENDDO
            CALL RESIDSUM(NT,NCROW,iHALF,DISTMAT,RS)
            nold=nhist
            NHIST=NHIST+1
         ENDIF
         noldloop=nloop
         NLOOP=NLOOP+1
C***  END OF THE LOOP OF INDEX I
      ENDDO
      loopold=loop
      loop=loop+1
      call printlp(Maxloop,loopold,loop,nold,nhist,noldloop,nloop)
      IF((NHIST .EQ. NHISTOLD) .OR. (loop .eq. maxloop)) GO TO 1000
      GO TO 100
 1000 RETURN
      END
      
c**** subroutine to fill in the omega ( or K) matrix for 
c**** ridge regression S funcion
c**** K_ij= radfun( distance( x1_i, x2_j))
c
       subroutine SQDIST( nd,x1,n1, x2,n2, par, k)
       implicit double precision (a-h,o-z)
       integer nd,n1,n2,ic
       
       real*8 par(1),x1(n1,nd), x2(n2,nd), k(n1,n2)
c **** loop through columns of output matrix K
c*** outer most loop over columns of x1 and x2 should reduce paging 

       do 5 ic= 1, nd
          do 10 j =1,n2
             xtemp= x2(j,ic)
             do  15 i= 1, n1
c     
c**   accumulate sqared differences
c     
c                k(i,j)=  (x1(i,ic)- xtemp)**2 + k(i,j)
                k(i,j)=  (x1(i,ic)- xtemp)*(x1(i,ic)-xtemp) + k(i,j)
 15          continue
 10       continue
 5     continue

c**** at this point k( i,j) is the squared distnace between x1_i and x2_j
c*** now evaluate radial basis functions
         nbig= n1*n2
c***** Now evalute the radial basis functions with the
c      distances. radfun will just loop through the matrix 
c as stacked column vectors. 

         call sqfun( nbig,k(1,1),par)

         return
       end
C** evaluates radial basis functions 
c**** K_ij= radfun( distance( x1_i, x2_j))
c

       subroutine sqfun(n,d2, par)
       real*8 d2(n), par(2), dtemp
       integer n

       if( int(par(2)).eq.0) then
         
         do 5 k =1,n
           dtemp= d2(k)
           if( dtemp.lt.1e-20) dtemp =1e-20 
c         d2(k)= (dtemp)**( par(1))
         d2(k)= (dtemp)
   5     continue
        else 
         do 6 k=1,n
          dtemp= d2(k)
          if( dtemp.gt.1e-20)  then
c           d2(k)=  log(dtemp)*(dtemp)**( par(1))
           d2(k)=  log(dtemp)*(dtemp)
          else
           d2(k)=0.0
          endif
   6   continue
       endif
       return
       end
       
       
