"tpsreg"<-
function(x, y, lambda, m, clean = T)
{
### run the tps program while in S
### data file is tps.dat
	out <- list()
	class(out) <- "tpsreg"
	out$N <- nrow(x)
	ndim <- ncol(x)
	out$call <- match.call()	#
#
	out$transform <- list(x.center = rep(0, ndim), x.scale = rep(1, ndim))
	out$tag <- 1	#
#
	if(missing(lambda)) {
		gcv <- 1
	}
	else gcv <- 101
	ncov <- 0	#
	x <- as.matrix(x)
	d <- ncol(x)	#print(d)
###  default for m
	if(missing(m))
		m <- ceiling((d + 2)/2)
	out$m <- m
	out$power <- 2 * m - d
	out$with.constant <- T	##########
#########
	write(t(cbind(x, y)), "tps.dat", ncol = (d + 1))
	write(c(d, m, ncov, gcv), "tps.in")
	if(!missing(lambda))
		write(lambda, "tps.in", append = T)
	write("tps.dat", "tps.in", append = T)
	write(deparse(match.call()), "tps.in", append = T)
	cat("Running thinplate spline program in the shell", fill = T)
	TPSREG <- paste(FUNFITS.BIN, "tpsreg", sep = "")
	call.shell(paste(TPSREG, "< tps.in  > tps.sum"))
	cat(" Output from tps is in the file  tps.sum", fill = T)	
	## nobs,dim,m,ncov1,(iout(k),k=1,4)
	parms <- scan("tps.par")
	print(parms)
	dim <- parms[2]
	np <- parms[6]
	out$np <- np
	nk <- parms[8]
	nt <- parms[7]
	out$nk <- nk
	spar <- parms[9]	#	print(parms)
	cat(" Reading in estimated spline at the data points", fill = T)
	tps.spline <- matrix(scan("tps.spl"), ncol = 2, byrow = T)
	gcvf <- scan("tps.gcv")
	gcvf <- matrix(gcvf, ncol = 3, byrow = T)	#
#
	out$x <- x
	out$y <- y
	out$yname <- as.character(paste(substitute(y)))
	out$summary <- scan("tps.sum", what = "a", sep = "\n")
	class(out$summary) <- "text"
	out$residuals <- tps.spline[, 2]
	out$nt <- nt
	offset <- 8 + ndim * nk
	print(offset)
	out$coefficients <- scan("tps.ev")
	out$knots <- matrix(out$coefficients[8 + 1:(ndim * nk)], ncol = ndim, 
		nrow = nk, byrow = T)
	out$d <- out$coefficients[(1:nt) + offset]
	out$c <- out$coefficients[(nt + offset) + (1:nk)]
	out$fitted.values <- tps.spline[, 1]
	out$gcv.grid <- gcvf
	out$parameters <- parms	
	##         read in the coefficients of the  spline          
	out$spar <- spar
	out$eff.df <- parms[10]
	if(clean) {
		remove.file("tps.ev")
		remove.file("tps.spl")
		remove.file("tps.sum")
		remove.file("tps.gcv")
		remove.file("tps.in")
		remove.file("tps.dat")
		remove.file("tps.in")
	}
	out
}
