"smooth.test"<-
function(out = hm7.tps)
{
	N <- out$N
	nt <- out$nt
	np <- out$np
	D <- out$matrices$D
	G <- out$matrices$G
	X <- out$matrices$X
	u <- out$matrices$u
	lambda <- out$lambda
	ss.pure <- ifelse(is.na(out$pure.ss), 0, out$pure.ss)
	shat.pure.error <- out$shat.pure.error
	df.lm <- N - out$nt
	df.tps <- N - out$eff.df
	lambdaD <- D * lambda
	Dterm <- lambdaD/(1 + lambdaD)
	u2 <- u[1:(np - out$nt),  ]	#sse.tps <- RSS[cbind(il,1:nsim)]
#sse.lm <- sum((u[1:(N - out$nt)])^2)
	sse.tps <- ss.pure + sum((u * Dterm)^2)
	sse.lm <- sum((u[1:(np - out$nt)])^2)
	df.tps <- N - out$eff.df	#wahba test
	V.lambda <- sse.tps/df.tps^2
	V.null <- sse.lm/df.lm^2
	wahba.test <- V.lambda/V.null	#reduced model test
	rm.test <- ((sse.lm - sse.tps)/(df.lm - df.tps))/(sse.tps/df.tps)	
	#max fold test
	sdu <- sqrt(var(u2))
	normu <- u2/sdu
	mf.test <- max(abs(normu))	#eubanks test
#lambdaD2 <- lambdaD[1:(np - out$nt)]
#eub.s <- eubanks.s.fun(out$x,out$y,n.p=3)$shat
#eubanks.test <- (colsum(u2^2/(1+lambdaD2)^2) - eub.s^2*colsum(1/(1+lambdaD2)^2))/eub.s^2*sqrt(2*colsum(1/(1+lambdaD2)^4))
	sd.null <- ifelse(is.na(shat.pure.error), 0.5, shat.pure.error)
	null.dist <- tps.sim.null1(out = out, nsim = 1000, u.var = sd.null)	
	#null.dist2 <- tps.sim.null1(out=out,nsim=1000,u.var=1)
#par(mfrow=c(2,1))
#hist(null.dist$wahba.null)
#abline(v=wahba.test)
#hist(null.dist$rm.null)
#abline(v=rm.test)
	wahba.pval <- (sum(null.dist$wahba.null < wahba.test)/1000)
	rm.pval <- (sum(null.dist$rm.null > rm.test)/1000)
	mf.pval <- (sum(null.dist$mf.null > mf.test)/1000)
	wahba <- cbind(test = wahba.test, cval = as.numeric(null.dist$cval$
		wahba), pval = (sum(null.dist$wahba.null < wahba.test)/1000))
	rm <- cbind(test = rm.test, cval = as.numeric(null.dist$cval$rm), pval
		 = (sum(null.dist$rm.null > rm.test)/1000))
	mf <- cbind(test = mf.test, cval = as.numeric(null.dist$cval$maxft), 
		pval = (sum(null.dist$mf.null > mf.test)/1000))
	tests <- list(wahba = wahba, reduced.model = rm, max.fold = mf)
	tests
}
