"predict.surface.se"<-
function(out, grid.list = NA, extrap = F, chull.mask, ...)
{
	if((length(grid.list) == 1) | (is.na(grid.list)[1])) {
		grid.list <- as.list(rep("c", ncol(out$x)))
		grid.list[[1]] <- "x"
		grid.list[[2]] <- "y"
		temp <- dimnames(out$x)[[2]]
		if(!(temp[1] == "")) names(grid.list) <- temp	#print(grid.list)
	}
	if(is.null(out$x))
		xg <- make.surface.grid(grid.list)
	else xg <- make.surface.grid(grid.list, X = out$x)
	out2 <- as.surface(xg, predict.se(out, xg, ...))
	if(!extrap) {
		if(missing(chull.mask)) {
			ind <- c(attr(xg, "format")[, 1])
			chull.mask <- out$x[, ind]
		}
		chull.mask <- unique.matrix(chull.mask)
		mask.temp <- interp(chull.mask[, 1], chull.mask[, 2], rep(1, 
			length(chull.mask[, 1])), xo = out2$x, yo = out2$y)$z
		out2$z <- ifelse(mask.temp == 1, out2$z, NA)
	}
	out2	#
#list(x = out2$x, y = out2$y, z = out2$z, grid.list = grid.list)
}
