"path"<-
function(fit, r, x.center, x.scale, maximize = T, scale = 0.0001, start, 
	trace.z = F)
{
## find the path of steepest ascent or equivalently the 
## rising ridge for any method that has a predict function
## (not really this general because of need to find defaults
##  for x.center and x.scale)
## r is a vector of increasing values for the radii of the
## hyperspheres
## x.center is the center of the hyperspheres (in the original coordinates
## of the experimental variables
## x.scale is the scale of the hyperspheres (in the original coordinates)
	if(missing(x.scale)) {
		if(!is.null(fit$transform$x.scale))
			x.scale <- fit$transform$x.scale
		else x.scale <- 1
	}
	if(missing(x.center)) {
		if(!is.null(fit$transform$x.center))
			x.center <- fit$transform$x.center
		else x.center <- 0
	}
	z <- function(theta, r, x.center, x.scale, fit = fit, maximize, trace.z,
		x.mat)
	{
## this is the polar version of the original function
## set up so that it can be sent to nlminb
		d <- ncol(x.mat)
		xt <- rep(NA, d)
		xt[1] <- r * sin(theta[1])
		if(d > 2)
			for(i in 2:(d - 1)) {
				xp <- prod(cos(theta[1:(i - 1)]))
				xt[i] <- r * xp * sin(theta[i])
			}
		xt[d] <- r * prod(cos(theta))
		x <- xt * x.scale + x.center
		x <- matrix(x, nrow = 1, dimnames = list(1, dimnames(x.mat)[[2
			]]))
		y <- predict(fit, data.frame(x))
		if(trace.z)
			cat("theta =", round(theta, 3), ",  ", "x =", round(x, 
				1), "r =", round(r, 2), "y =", round(y, 1), 
				"\n")
		if(maximize)
			return(-1 * y)
		else return(y)
	}
## now find the thetas that correspond to the maximum (min)
## response on the hypersphere of radius r
	if(!is.na(charmatch("lm", class(fit)))) {
		if(!is.null(fit$model))
			x <- as.matrix(fit$model[, -1])
		else stop("Error: Must call lm with model=T")
	}
	else x <- fit$x
	d <- ncol(x)
	if(missing(start))
		start <- rep(0, d - 1)
	lower <- c(rep( - pi/2, d - 2),  - pi)
	upper <- c(rep(pi/2, d - 2), pi)
	n.r <- length(r)
	theta.r <- matrix(NA, ncol = d, nrow = n.r)
	for(i in 1:n.r) {
		nlminb.out <- nlminb(start, z, fit = fit, r = r[i], x.center = 
			x.center, x.scale = x.scale, x.mat = x, trace.z = 
			trace.z, maximize = maximize, scale = scale)	
	##			   upper =  upper, lower = lower)
		theta.r[i, 1:d - 1] <- nlminb.out$par
		theta.r[i, d] <- nlminb.out$obj * ifelse(maximize, -1, 1)
	}
## now convert back to the original units again
	path.out <- matrix(NA, ncol = d + 2, nrow = n.r)
	dimnames(path.out) <- list(1:n.r, c(dimnames(x)[[2]], "Radius", "yhat")
		)
	for(j in 1:n.r) {
		theta <- theta.r[j, 1:d - 1]
		path.out[j, 1] <- r[j] * sin(theta[1])
		if(d > 2)
			for(i in 2:(d - 1)) {
				xp <- prod(cos(theta[1:(i - 1)]))
				path.out[j, i] <- r[j] * xp * sin(theta[i])
			}
		path.out[j, d] <- r[j] * prod(cos(theta))
		path.out[j, 1:d] <- path.out[j, 1:d] * x.scale + x.center
	}
	path.out[, d + 1] <- r
	path.out[, d + 2] <- theta.r[, d]
	path.out
}
