"persp.tiles"<-
function(tile.list, back.to.front = T, col = NULL, ...)
{
# find distance to center of the tile
	m <- ncol(tile.list$X)
	N <- nrow(tile.list$X)
	if(is.null(col))
		col <- rep(0, N)
	if(length(col) == 1)
		col <- rep(col, N)
	one.n <- rep(1/m, m)
	x <- tile.list$X %*% one.n
	y <- tile.list$Y %*% one.n
	z <- tile.list$Z %*% one.n
	if(back.to.front) {
		deye <- perspp.dist(x, y, z)
		id <- rev(order(deye))
		tile.list$X <- tile.list$X[id,  ]
		tile.list$Y <- tile.list$Y[id,  ]
		tile.list$Z <- tile.list$Z[id,  ]
		col <- col[id]
	}
	for(kk in 1:N) {
		persp.polygon(tile.list$X[kk,  ], tile.list$Y[kk,  ], tile.list$
			Z[kk,  ], col = col[kk], ...)
		persp.lines(tile.list$X[kk,  ], tile.list$Y[kk,  ], tile.list$Z[
			kk,  ])
	}
}
