"optim"<-
function(fit, start, maximize = T, lower, upper, ...)
{
## this was formerly optim.tpsreg, but now it should work generally
## for any method with a predict function
## the default is to start in the middle of the experimental region
## and to look for an optimum within the region
	if(!is.na(charmatch("lm", class(fit)))) {
		if(!is.null(fit$model))
			x <- as.matrix(fit$model[, -1])
		else stop("Error: Must call lm with model=T")
	}
	else x <- fit$x
	if(missing(start))
		start <- apply(x, 2, mean)
	if(missing(lower))
		lower <- apply(x, 2, min)
	if(missing(upper)) upper <- apply(x, 2, max)	
	## the default is to look for the maximum
	if(maximize)
		f <- function(x, fit, x.mat)
		{
			x <- matrix(x, nrow = 1, dimnames = list(1, dimnames(
				x.mat)[[2]]))
			y <-  - predict(fit, data.frame(x))
			y
		}
	else f <- function(x, fit, x.mat)
		{
			x <- matrix(x, nrow = 1, dimnames = list(1, dimnames(
				x.mat)[[2]]))
			predict(fit, data.frame(x))
		}
	optim.out <- nlminb(start, f, fit = fit, upper = upper, lower = lower, 
		x.mat = x, ...)
	optim.out$aux <- NULL
	optim.out
}
